/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.heat;

import com.denfop.api.heat.IHeatNet;
import com.denfop.api.heat.IHeatTile;
import com.denfop.heat.EventHandler;
import com.denfop.heat.HeatNetLocal;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class HeatNetGlobal
implements IHeatNet {
    private static Map<ResourceKey<Level>, HeatNetLocal> worldToEnergyNetMap = new WeakHashMap<ResourceKey<Level>, HeatNetLocal>();

    public static HeatNetGlobal initialize() {
        new EventHandler();
        return new HeatNetGlobal();
    }

    public static void onWorldUnload(Level world) {
        HeatNetLocal local = worldToEnergyNetMap.remove(world.m_46472_());
        if (local != null) {
            local.onUnload();
        }
    }

    public static HeatNetLocal getForWorld(Level world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world.m_46472_())) {
            worldToEnergyNetMap.put((ResourceKey<Level>)world.m_46472_(), new HeatNetLocal());
        }
        return worldToEnergyNetMap.get(world.m_46472_());
    }

    public static void onTickEnd(Level world) {
        HeatNetLocal energyNet = HeatNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public IHeatTile getSubTile(Level var1, BlockPos var2) {
        HeatNetLocal local = HeatNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }
}

