/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.advrefiner;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AdvRefinerHandler {
    private static final List<AdvRefinerHandler> recipes = new ArrayList<AdvRefinerHandler>();
    private final FluidStack output1;
    private final FluidStack input;
    private final FluidStack output;

    public AdvRefinerHandler(FluidStack input, FluidStack output, FluidStack output1) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
    }

    public static List<AdvRefinerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AdvRefinerHandler.initRecipes();
        }
        return recipes;
    }

    public static AdvRefinerHandler addRecipe(FluidStack input, FluidStack output, FluidStack output1) {
        AdvRefinerHandler recipe = new AdvRefinerHandler(input, output, output1);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static AdvRefinerHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("adv_oil_refiner")) {
            FluidStack fluidStack = machineRecipe.getInput().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getOutput_fluid().get(0);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(1);
            double m = 1000.0 / (double)fluidStack.getAmount();
            AdvRefinerHandler.addRecipe(new FluidStack(fluidStack.getFluid(), (int)(m * (double)fluidStack.getAmount())), new FluidStack(fluidStack1.getFluid(), (int)(m * (double)fluidStack1.getAmount())), new FluidStack(fluidStack2.getFluid(), (int)(m * (double)fluidStack2.getAmount())));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

