/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.itemdivider;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ItemDividerHandler {
    private static final List<ItemDividerHandler> recipes = new ArrayList<ItemDividerHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;

    public ItemDividerHandler(ItemStack input, ItemStack output, FluidStack inputFluid, FluidStack outputFluid) {
        this.input = input;
        this.output = output;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
    }

    public static List<ItemDividerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ItemDividerHandler.initRecipes();
        }
        return recipes;
    }

    public static ItemDividerHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        List<BaseFluidMachineRecipe> list = Recipes.recipes.getRecipeFluid().getRecipeList("item_divider");
        List<BaseMachineRecipe> list1 = Recipes.recipes.getRecipeList("item_divider");
        for (int i = 0; i < list1.size(); ++i) {
            BaseFluidMachineRecipe baseFluidMachineRecipe = list.get(i);
            BaseMachineRecipe baseMachineRecipe = list1.get(i);
            ItemStack input = baseMachineRecipe.input.getInputs().get(0).getInputs().get(0);
            ItemStack output = baseMachineRecipe.getOutput().items.get(0);
            FluidStack inputFluid = baseFluidMachineRecipe.output_fluid.get(0);
            FluidStack outputFluid = baseFluidMachineRecipe.output_fluid.get(1);
            ItemDividerHandler.addRecipe(input, output, inputFluid, outputFluid);
        }
    }

    private static ItemDividerHandler addRecipe(ItemStack input, ItemStack output, FluidStack inputFluid, FluidStack outputFluid) {
        ItemDividerHandler recipe = new ItemDividerHandler(input, output, inputFluid, outputFluid);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }
}

