/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.moon_spotter;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class MoonSpooterHandler {
    private static final List<MoonSpooterHandler> recipes = new ArrayList<MoonSpooterHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public MoonSpooterHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<MoonSpooterHandler> getRecipes() {
        if (recipes.isEmpty()) {
            MoonSpooterHandler.initRecipes();
        }
        return recipes;
    }

    public static MoonSpooterHandler addRecipe(ItemStack input, ItemStack output) {
        MoonSpooterHandler recipe = new MoonSpooterHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static MoonSpooterHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (MoonSpooterHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("solar_glass_recipe")) {
            MoonSpooterHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

