/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.pellets;

import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.blocks.mechanism.BlockMoreMachine3;
import com.denfop.container.ContainerMultiMachine;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.pellets.PelletsHandler;
import com.denfop.tiles.mechanism.multimechanism.simple.TileOreWashing;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PelletsCategory
extends GuiIU
implements IRecipeCategory<PelletsHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public PelletsCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(new ContainerMultiMachine((Player)Minecraft.m_91087_().f_91074_, (TileOreWashing)BlockMoreMachine3.orewashing.getDummyTe(), 1, true));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guipallet.png"), 5, 3, 165, 77);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3.pallet_generator).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(PelletsHandler recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        PelletsCategory.bindTexture(this.getTexture());
        for (int x = 30; x <= 68; x += 18) {
            for (int y = 18; y <= 36; y += 18) {
                this.drawTexturedModalRect(stack, 0 + x, 0 + y, 179, 30, 18, 18);
            }
        }
        double num = 20000.0 / Math.ceil(recipe.getInput());
        this.drawSplitString(stack, String.format("%.2f\u2622 -> 50 EF", num), 90, 30, 190, ModUtils.convertRGBcolorToInt(255, 255, 255));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PelletsHandler recipe, IFocusGroup focuses) {
        for (int i = 0; i < recipe.getCol(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 31 + i % 3 * 18, 19 + i / 3 * 18).addItemStack(recipe.getInput2());
        }
    }

    public RecipeType<PelletsHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guipallet.png");
    }
}

