/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.quarry;

import com.denfop.IUCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class QuarryHandler {
    private static final List<QuarryHandler> recipes = new ArrayList<QuarryHandler>();
    private final ItemStack output;

    public QuarryHandler(ItemStack output) {
        this.output = output;
    }

    public static List<QuarryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            QuarryHandler.initRecipes();
        }
        return recipes;
    }

    public static QuarryHandler addRecipe(ItemStack output) {
        QuarryHandler recipe = new QuarryHandler(output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static QuarryHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (QuarryHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (ItemStack container : IUCore.list) {
            QuarryHandler.addRecipe(container);
        }
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return is.m_41720_() == this.output.m_41720_();
    }
}

