/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.blocks.ISubEnum;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemWaterRod;
import com.denfop.items.ItemWaterRotor;
import com.denfop.tiles.hydroturbine.TileEntityHydroTurbineController;
import net.minecraft.world.item.ItemStack;

public class InvSlotHydroTurbineRotorBlades
extends InvSlot
implements ITypeSlot {
    private final TileEntityHydroTurbineController windGenerator;

    public InvSlotHydroTurbineRotorBlades(TileEntityHydroTurbineController windGenerator) {
        super(windGenerator, InvSlot.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(64);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.WATER_ROD_PART;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        if (this.windGenerator.getRotor() == null) {
            return false;
        }
        if (this.windGenerator.getRotor() != null && stack.m_41720_() instanceof ItemWaterRod) {
            return ((ItemWaterRod)stack.m_41720_()).getLevel(this.windGenerator.getRotor().getLevel(), ((ISubEnum)((ItemWaterRod)stack.m_41720_()).getElement()).getId());
        }
        return false;
    }

    public void consume(int amount) {
        this.consume(amount, false);
    }

    public void work() {
        if (this.get(0).m_41619_()) {
            return;
        }
        ItemStack stack = this.windGenerator.slot.get(0);
        if (this.windGenerator.getRotor() != null && this.get(0).m_41720_() instanceof ItemWaterRod && ((ItemWaterRod)this.get(0).m_41720_()).getLevel(this.windGenerator.getRotor().getLevel(), ((ISubEnum)((ItemWaterRod)this.get(0).m_41720_()).getElement()).getId()) && (double)((ItemWaterRotor)stack.m_41720_()).getCustomDamage(stack) <= (double)((ItemWaterRotor)stack.m_41720_()).getMaxCustomDamage(stack) * 0.75) {
            this.windGenerator.slot.damage((int)((double)(-1 * ((ItemWaterRotor)stack.m_41720_()).getMaxCustomDamage(stack)) * 0.25), 0.0);
            this.get(0).m_41774_(1);
        }
    }

    public void consume(int amount, boolean simulate) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (stack.m_41619_() || amount <= 0) continue;
            int currentAmount = Math.min(amount, stack.m_41613_());
            if (!simulate) {
                stack.m_41774_(currentAmount);
            }
            if ((amount -= currentAmount) == 0) break;
        }
    }
}

