/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour.special;

import com.denfop.ElectricItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.armour.special.ContainerLegsBags;
import com.denfop.items.armour.special.GuiLegsBags;
import com.denfop.items.bags.BagsDescription;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStackLegsBags
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    private final double coef;

    public ItemStackLegsBags(Player player, ItemStack stack) {
        super(player, stack, 45);
        this.inventorySize = 45;
        this.itemStack1 = stack;
        this.coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        this.updatelist();
    }

    @Override
    public ContainerBase<ItemStackLegsBags> getGuiContainer(Player player) {
        return new ContainerLegsBags(player, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player player, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiLegsBags((ContainerLegsBags)isAdmin, this.itemStack1);
    }

    @Override
    public ItemStackInventory getParent() {
        return this;
    }

    @Override
    public void addInventorySlot(InvSlot var1) {
    }

    @Override
    public int getBaseIndex(InvSlot var1) {
        return 0;
    }

    @Override
    @Nonnull
    public String getName() {
        return "toolbox";
    }

    public boolean hasCustomName() {
        return false;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
            stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
        }
        this.inventory[slot] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        this.updatelist();
        this.save();
    }

    private void updatelist() {
        ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
        for (ItemStack stack : this.inventory) {
            if (stack == null || stack.m_41619_()) continue;
            if (list.isEmpty()) {
                list.add(new BagsDescription(stack));
                continue;
            }
            if (list.contains(new BagsDescription(stack))) {
                ((BagsDescription)list.get(list.indexOf(new BagsDescription(stack)))).addCount(stack.m_41613_());
                continue;
            }
            list.add(new BagsDescription(stack));
        }
        CompoundTag nbt = ModUtils.nbt(this.containerStack);
        CompoundTag nbt1 = new CompoundTag();
        nbt1.m_128405_("size", list.size());
        for (int i = 0; i < list.size(); ++i) {
            nbt1.m_128365_(String.valueOf(i), (Tag)((BagsDescription)list.get(i)).write(new CompoundTag()));
        }
        nbt.m_128365_("bag", (Tag)nbt1);
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    public ItemStack[] getAll() {
        return this.inventory;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
        this.save();
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).m_41619_()) {
                        if (!simulate) {
                            this.put(i, stack.m_41777_());
                            stack.m_41764_(0);
                        }
                        return true;
                    }
                    if (!this.get(i).m_150930_(stack.m_41720_()) || this.get(i).m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        if (!simulate) {
                            this.get(i).m_41769_(stack.m_41613_());
                            stack.m_41764_(0);
                        }
                        return true;
                    }
                    if (stack.m_41783_() == null || !stack.m_41783_().equals((Object)this.get(i).m_41783_())) continue;
                    if (!simulate) {
                        this.get(i).m_41769_(stack.m_41613_());
                        stack.m_41764_(0);
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        if (ElectricItem.manager.canUse(this.itemStack1, 50.0 * this.coef)) {
            return !itemstack.m_41619_();
        }
        return false;
    }
}

