/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy.instruments;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrade.ILevelInstruments;
import com.denfop.api.upgrade.IUpgradeWithBlackList;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemBlackListLoad;
import com.denfop.audio.EnumSound;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.IProperties;
import com.denfop.items.energy.ItemStackUpgradeItem;
import com.denfop.items.energy.instruments.EnumOperations;
import com.denfop.items.energy.instruments.EnumTypeInstruments;
import com.denfop.items.energy.instruments.EnumVarietyInstruments;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.proxy.CommonProxy;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.ModUtils;
import com.denfop.utils.RetraceDiggingUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemEnergyInstruments
extends Item
implements IEnergyItem,
IItemStackInventory,
IUpgradeWithBlackList,
ILevelInstruments,
IProperties {
    private final String name;
    private final int transferLimit;
    private final int maxCharge;
    private final int tier;
    private final int normalPower;
    private final int bigHolePower;
    private final int energyPerOperation;
    private final int energyBigHolePowerOperation;
    private final int ultraLowPower1;
    private final int ultraLowPower;
    private final Set<BlockState> mineableBlocks;
    private final Set<Material> materials;
    private final int energyPerbigHolePowerOperation;
    private final int energyPerultraLowPowerOperation;
    private final List<EnumOperations> operations;
    private final List<TagKey<Block>> item_tools;
    private final String name_type;
    private final float fuel_balance = 10.0f;
    private final EnumTypeInstruments type;
    Set<String> toolType;
    private int efficiency;
    private String nameItem;

    public ItemEnergyInstruments(EnumTypeInstruments type, EnumVarietyInstruments variety, String name) {
        super(new Item.Properties().setNoRepair().m_41491_(IUCore.EnergyTab).m_41487_(1));
        this.name = name;
        this.type = type;
        this.name_type = type.getType_name() == null ? type.name().toLowerCase() : type.getType_name();
        this.transferLimit = variety.getEnergy_transfer();
        this.maxCharge = variety.getCapacity();
        this.tier = variety.getTier();
        this.efficiency = this.normalPower = variety.getNormal_power();
        this.bigHolePower = variety.getBig_holes();
        this.energyPerOperation = variety.getEnergyPerOperation();
        this.energyBigHolePowerOperation = variety.getEnergyPerBigOperation();
        this.energyPerbigHolePowerOperation = variety.getEnergyPerbigHolePowerOperation();
        this.energyPerultraLowPowerOperation = variety.getEnergyPerultraLowPowerOperation();
        this.ultraLowPower = variety.getMega_holes();
        this.ultraLowPower1 = variety.getUltra_power();
        this.mineableBlocks = type.getMineableBlocks();
        this.materials = type.getMaterials();
        this.toolType = type.getToolType();
        this.operations = type.getListOperations();
        this.item_tools = type.getListItems();
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, type.getEnumInfoUpgradeModules()));
    }

    @Override
    public int getMaxLevel(ItemStack stack) {
        int maxLevel = ILevelInstruments.super.getMaxLevel(stack);
        if (maxLevel == Integer.MAX_VALUE) {
            return maxLevel;
        }
        maxLevel = (int)((double)maxLevel * Math.max(0.5, 0.5 * (double)this.tier));
        return maxLevel;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        float energy;
        List<UpgradeItemInform> upgradeItemInforms;
        Block block = state.m_60734_();
        if (block.equals(Blocks.f_50016_)) {
            return false;
        }
        if (state.m_60767_().m_76332_() || state.m_60734_().m_155943_() == 0.0f && !((Player)entity).m_7500_()) {
            return false;
        }
        if (!world.f_46443_) {
            if (ForgeHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)entity).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)entity), (BlockPos)pos) == -1) {
                return false;
            }
            if (block.onDestroyedByPlayer(state, world, pos, (Player)((ServerPlayer)entity), true, world.m_6425_(pos))) {
                upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
                boolean smelter = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SMELTER, stack, upgradeItemInforms);
                boolean comb = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.COMB_MACERATOR, stack, upgradeItemInforms);
                boolean mac = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.MACERATOR, stack, upgradeItemInforms);
                boolean generator = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENERATOR, stack, upgradeItemInforms);
                int random = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RANDOM, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RANDOM, (ItemStack)stack, upgradeItemInforms).number : 0;
                CompoundTag nbt = ModUtils.nbt(stack);
                boolean black_list = nbt.m_128471_("black");
                block.m_6786_((LevelAccessor)world, pos, state);
                block.m_6240_(world, (Player)((ServerPlayer)entity), pos, state, null, stack);
                List items = entity.m_9236_().m_45976_(ItemEntity.class, new AABB((double)(pos.m_123341_() - 1), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)));
                this.addExperience(stack, 1);
                if (!black_list && this.check_list(block, 0, UpgradeSystem.system.getBlackList(stack))) {
                    int rand;
                    for (ItemEntity item : items) {
                        RecipeOutput rec;
                        if (entity.m_9236_().f_46443_) continue;
                        ItemStack stack1 = item.m_32055_();
                        if (comb) {
                            rec = Recipes.recipes.getRecipeOutput((String)"comb_macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output;
                            if (rec != null) {
                                stack1 = rec.items.get(0).m_41777_();
                                stack1.m_41764_(3);
                            }
                        } else if (mac && (rec = Recipes.recipes.getRecipeOutput((String)"macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output) != null) {
                            stack1 = rec.items.get(0).m_41777_();
                        }
                        ItemStack smelt = new ItemStack((ItemLike)Items.f_41852_);
                        if (smelter && !(smelt = ModUtils.getRecipeFromType(world, stack1, (RecipeType<SmeltingRecipe>)RecipeType.f_44108_)).m_41619_()) {
                            smelt.m_41764_(stack1.m_41613_());
                        }
                        if (generator) {
                            boolean rec2;
                            int fuel = ModUtils.getFuelValue(stack1, false);
                            boolean bl = rec2 = fuel > 0;
                            if (rec2) {
                                int amount = stack1.m_41613_();
                                int value = fuel / 4;
                                amount *= value;
                                amount = (int)((float)amount * 10.0f);
                                double sentPacket = ElectricItem.manager.charge(stack, amount, Integer.MAX_VALUE, true, false);
                                amount = (int)((double)amount - sentPacket);
                                amount = (int)((float)amount / ((float)value * 10.0f));
                                stack1.m_41764_(amount);
                            }
                        }
                        if (!smelt.m_41619_()) {
                            item.m_32045_(smelt);
                        } else {
                            item.m_32045_(stack1);
                        }
                        item.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.m_32010_(0);
                    }
                    if (random != 0 && (rand = world.f_46441_.m_188503_(100001)) >= 100000 - random) {
                        ItemEntity item;
                        item = new ItemEntity(EntityType.f_20461_, world);
                        item.m_32045_(IUCore.get_ingot.get(world.f_46441_.m_188503_(IUCore.get_ingot.size())));
                        item.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.m_32010_(0);
                    }
                } else {
                    int rand;
                    if (nbt.m_128471_("black")) {
                        for (ItemEntity item : items) {
                            if (entity.m_9236_().f_46443_) continue;
                            item.m_142687_(Entity.RemovalReason.KILLED);
                        }
                    }
                    if (random != 0 && (rand = world.f_46441_.m_188503_(100001)) >= 100000 - random) {
                        ItemEntity item;
                        item = new ItemEntity(EntityType.f_20461_, world);
                        item.m_32045_(IUCore.get_ingot.get(world.f_46441_.m_188503_(IUCore.get_ingot.size())));
                        item.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.m_32010_(0);
                    }
                }
            }
        } else if (block.onDestroyedByPlayer(state, world, pos, (Player)entity, true, world.m_6425_(pos))) {
            block.m_6786_((LevelAccessor)world, pos, state);
        }
        if (entity.m_6084_() && (energy = this.energy(stack, upgradeItemInforms = UpgradeSystem.system.getInformation(stack))) != 0.0f) {
            ElectricItem.manager.use(stack, energy, entity);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand hand) {
        CompoundTag nbt;
        ItemStack itemStack = player.m_21120_(hand);
        if (IUCore.keyboard.isSaveModeKeyDown(player)) {
            boolean save;
            nbt = ModUtils.nbt(itemStack);
            boolean bl = save = !nbt.m_128471_("save");
            if (!worldIn.f_46443_) {
                CommonProxy.sendPlayerMessage(player, ChatFormatting.GREEN + Localization.translate("message.savemode") + (save ? Localization.translate("message.allow") : Localization.translate("message.disallow")));
            }
            nbt.m_128379_("save", save);
        }
        if (IUCore.keyboard.isBlackListModeKeyDown(player)) {
            boolean black;
            nbt = ModUtils.nbt(itemStack);
            boolean bl = black = !nbt.m_128471_("black");
            if (!worldIn.f_46443_) {
                CommonProxy.sendPlayerMessage(player, ChatFormatting.GREEN + Localization.translate("message.blacklist") + (black ? Localization.translate("message.allow") : Localization.translate("message.disallow")));
            }
            nbt.m_128379_("black", black);
        }
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int toolMode = this.readToolMode(itemStack) + 1;
            if (!worldIn.f_46443_) {
                worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), EnumSound.toolchange.getSoundEvent(), SoundSource.MASTER, 1.0f, 1.0f);
            }
            if (toolMode >= this.operations.size()) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            EnumOperations operation = this.operations.get(toolMode);
            if (!worldIn.f_46443_) {
                IUCore.proxy.messagePlayer(player, ChatFormatting.GREEN + Localization.translate("message.text.mode") + ": " + operation.getTextFormatting() + Localization.translate(operation.getName_mode()));
            }
            switch (operation) {
                case ORE: 
                case TREE: 
                case SHEARS: 
                case TUNNEL: 
                case DEFAULT: {
                    this.efficiency = this.normalPower;
                    break;
                }
                case BIGHOLES: {
                    this.efficiency = this.bigHolePower;
                    break;
                }
                case MEGAHOLES: {
                    this.efficiency = this.ultraLowPower;
                    break;
                }
                case ULTRAHOLES: {
                    this.efficiency = this.ultraLowPower1;
                }
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public int readToolMode(ItemStack itemstack) {
        CompoundTag nbt = ModUtils.nbt(itemstack);
        int toolMode = nbt.m_128451_("toolMode");
        if (toolMode < 0 || toolMode >= this.operations.size()) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int slot, boolean par5) {
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemBlackListLoad(world, this, itemStack, itemStack.m_41783_()));
        }
        if (entity instanceof Player && IUCore.keyboard.isBlackListModeViewKeyDown((Player)entity) && !entity.m_9236_().f_46443_ && !itemStack.m_41619_() && ((Player)entity).m_21120_(InteractionHand.MAIN_HAND).m_150930_(itemStack.m_41720_())) {
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)entity), (MenuProvider)this.getInventory((Player)entity, itemStack), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> items) {
        if (this.m_220152_(p_41391_)) {
            ItemStack stack = new ItemStack((ItemLike)this, 1);
            CompoundTag nbt = ModUtils.nbt(stack);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            nbt.m_128405_("ID_Item", Integer.MAX_VALUE);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((ItemLike)this, 1);
            nbt = ModUtils.nbt(itemstack);
            nbt.m_128405_("ID_Item", Integer.MAX_VALUE);
            items.add((Object)itemstack);
        }
    }

    public boolean m_8096_(BlockState p_150816_) {
        for (TagKey<Block> blockTagKey : this.item_tools) {
            if (!p_150816_.m_204336_(blockTagKey)) continue;
            return true;
        }
        return super.m_8096_(p_150816_);
    }

    public boolean m_7579_(ItemStack p_41395_, LivingEntity p_41396_, LivingEntity p_41397_) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public void m_7373_(ItemStack par1ItemStack, @Nullable Level p_41422_, List<Component> par3List, TooltipFlag p_41424_) {
        super.m_7373_(par1ItemStack, p_41422_, par3List, p_41424_);
        int toolMode = this.readToolMode(par1ItemStack);
        EnumOperations operations = this.operations.get(toolMode);
        par3List.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Localization.translate("message.text.mode") + ": " + operations.getTextFormatting() + Localization.translate(operations.getName_mode()))));
        par3List.add((Component)Component.m_237115_((String)operations.getDescription()));
        if (ModUtils.nbt(par1ItemStack).m_128471_("save")) {
            par3List.add((Component)Component.m_237113_((String)(ChatFormatting.GREEN + Localization.translate("iu.savemode_allow"))));
        }
        if (ModUtils.nbt(par1ItemStack).m_128471_("black")) {
            par3List.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_GRAY + Localization.translate("iu.blacklist_allow"))));
        }
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(par1ItemStack);
        if (operations != EnumOperations.DEFAULT && operations != EnumOperations.ORE && operations != EnumOperations.TREE) {
            int aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, par1ItemStack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)par1ItemStack, upgradeItemInforms).number : 0;
            int dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, par1ItemStack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)par1ItemStack, upgradeItemInforms).number : 0;
            par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.instruments.info") + (operations.getArea_x() + aoe) + "x" + (operations.getArea_y() + aoe) + "x" + (operations.getArea_z() + dig_depth))));
        }
        float energy = this.energy(par1ItemStack, upgradeItemInforms);
        par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.instruments.info2") + (int)energy + " EF")));
        if (!KeyboardIU.isKeyDown(340)) {
            par3List.add((Component)Component.m_237113_((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.changemode_key") + KeyboardClient.changemode.getKey().m_84875_().getString() + Localization.translate("iu.changemode_rcm"))));
            par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.blacklist_key") + KeyboardClient.blackmode.getKey().m_84875_().getString() + Localization.translate("iu.changemode_rcm"))));
            par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.savemode_key") + KeyboardClient.savemode.getKey().m_84875_().getString() + Localization.translate("iu.changemode_rcm"))));
            par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.blacklist_gui") + KeyboardClient.blacklistviewmode.getKey().m_84875_().getString())));
        }
        ModUtils.mode(par1ItemStack, par3List);
        int level = this.getLevel(par1ItemStack);
        int maxLevel = this.getMaxLevel(par1ItemStack);
        int experience = this.getExperience(par1ItemStack);
        par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.tier") + level)));
        par3List.add((Component)Component.m_237113_((String)(Localization.translate("iu.space_colony_experience") + experience + "/" + maxLevel)));
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    @Nonnull
    public Set<String> getToolClasses(@Nonnull ItemStack stack) {
        return this.toolType;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.mineableBlocks.contains(state)) {
            return true;
        }
        if (this.materials.contains(state.m_60767_())) {
            return true;
        }
        for (TagKey<Block> blockTagKey : this.item_tools) {
            if (!state.m_204336_(blockTagKey)) continue;
            return true;
        }
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        int speed;
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
        int n = speed = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.EFFICIENCY, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EFFICIENCY, (ItemStack)stack, upgradeItemInforms).number : 0;
        return !ElectricItem.manager.canUse(stack, this.energy(stack, upgradeItemInforms)) ? 0.0f : (this.isCorrectToolForDrops(stack, state) ? (float)(this.efficiency + (int)((double)this.efficiency * 0.2 * (double)speed)) : 1.0f);
    }

    void chopTree(BlockPos pos, Player player, Level world, ItemStack stack, List<BlockPos> list, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        int Y = pos.m_123342_();
        int X = pos.m_123341_();
        int Z = pos.m_123343_();
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= Y + 1; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    BlockPos pos1 = new BlockPos(xPos, yPos, zPos);
                    if (list.contains(pos1)) continue;
                    BlockState state = world.m_8055_(pos1);
                    Block block = state.m_60734_();
                    list.add(pos1);
                    if (!state.m_204336_(BlockTags.f_13106_)) continue;
                    if (!player.m_7500_()) {
                        this.onBlockDestroyed(stack, world, state, pos1, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                    }
                    this.chopTree(pos1, player, world, stack, list, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
            }
        }
    }

    private boolean isTree(Level world, BlockPos pos) {
        Block wood = world.m_8055_(pos).m_60734_();
        if (wood.equals(Blocks.f_50016_) || !wood.m_204297_().m_203656_(BlockTags.f_13106_)) {
            return false;
        }
        int top = pos.m_123342_();
        int Y = pos.m_123342_();
        int X = pos.m_123341_();
        int Z = pos.m_123343_();
        for (int y = pos.m_123342_(); y <= pos.m_123342_() + 50; ++y) {
            BlockPos pos1 = new BlockPos(X, y, Z);
            BlockState blockstate = world.m_8055_(pos1);
            if (blockstate.m_204336_(BlockTags.f_13106_) || blockstate.m_204336_(BlockTags.f_13035_)) continue;
            top += y;
            break;
        }
        int leaves = 0;
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= top; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    BlockPos pos1 = new BlockPos(xPos, yPos, zPos);
                    BlockState blockstate = world.m_8055_(pos1);
                    if (!blockstate.m_204336_(BlockTags.f_13035_)) continue;
                    ++leaves;
                }
            }
        }
        return leaves >= 3;
    }

    boolean break_block(Level world, Block block, BlockHitResult mop, byte mode_item, Player player, BlockPos pos, ItemStack stack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        byte xRange = mode_item;
        byte yRange = mode_item;
        byte zRange = mode_item;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        byte dig_depth = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0);
        switch (mop.m_82434_().ordinal()) {
            case 0: 
            case 1: {
                yRange = dig_depth;
                break;
            }
            case 2: 
            case 3: {
                zRange = dig_depth;
                break;
            }
            case 4: 
            case 5: {
                xRange = dig_depth;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
        int Yy = yRange > 0 ? yRange - 1 : 0;
        CompoundTag nbt = ModUtils.nbt(stack);
        float energy = this.energy(stack, upgradeItemInforms);
        boolean save = nbt.m_128471_("save");
        if (!player.m_7500_()) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block6: for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, energy)) {
                            BlockState state;
                            Block localBlock;
                            BlockPos pos_block = new BlockPos(xPos, yPos, zPos);
                            if (save && world.m_7702_(pos_block) != null || (localBlock = (state = world.m_8055_(pos_block)).m_60734_()).equals(Blocks.f_50016_) || !this.isCorrectToolForDrops(stack, state) || !(state.m_60800_((BlockGetter)world, pos_block) >= 0.0f)) continue;
                            if (state.m_60800_((BlockGetter)world, pos_block) >= 0.0f) {
                                this.onBlockDestroyed(stack, world, state, pos_block, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                            }
                            if (silktouch) continue;
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, fortune, stack, localBlock));
                            continue;
                        }
                        lowPower = true;
                        continue block6;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.m_8055_(pos);
            Block localBlock = state.m_60734_();
            if (!localBlock.equals(Blocks.f_50016_) && this.isCorrectToolForDrops(stack, state) && state.m_60800_((BlockGetter)world, pos) >= 0.0f || block == Blocks.f_50085_) {
                if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
            }
        }
        if (lowPower && ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.m_8055_(pos);
            Block localBlock = state.m_60734_();
            if (!localBlock.equals(Blocks.f_50016_) && this.isCorrectToolForDrops(stack, state) && state.m_60800_((BlockGetter)world, pos) >= 0.0f || block == Blocks.f_50085_) {
                if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
            }
        }
        return true;
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull Player player) {
        EnumOperations operations = this.operations.get(this.readToolMode(stack));
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        BlockHitResult mop = RetraceDiggingUtils.retrace(player);
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
        boolean smelter = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SMELTER, stack, upgradeItemInforms);
        boolean comb = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.COMB_MACERATOR, stack, upgradeItemInforms);
        boolean mac = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.MACERATOR, stack, upgradeItemInforms);
        boolean generator = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENERATOR, stack, upgradeItemInforms);
        int random = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RANDOM, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RANDOM, (ItemStack)stack, upgradeItemInforms).number : 0;
        CompoundTag nbt = ModUtils.nbt(stack);
        boolean black_list = nbt.m_128471_("black");
        List<String> list = UpgradeSystem.system.getBlackList(stack);
        switch (operations) {
            case DEFAULT: {
                if (block == Blocks.f_50016_) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case BIGHOLES: {
                if (block.equals(Blocks.f_50016_)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.m_6144_() && !mop.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(1 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case MEGAHOLES: {
                if (block.equals(Blocks.f_50016_)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.m_6144_() && !mop.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(2 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case ULTRAHOLES: {
                if (block.equals(Blocks.f_50016_)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.m_6144_() && !mop.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(3 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case ORE: {
                if (block.equals(Blocks.f_50016_)) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                boolean silktouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0;
                int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
                nbt.m_128405_("ore", 1);
                float energy = this.energy(stack, upgradeItemInforms);
                if (!mop.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    this.ore_break(world, pos, player, silktouch, fortune, false, stack, block, smelter, comb, mac, generator, random, black_list, energy, list);
                    return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case TREE: {
                if (this.isTree(player.m_9236_(), pos)) {
                    ArrayList<BlockPos> list1 = new ArrayList<BlockPos>();
                    float energy = this.energy(stack, upgradeItemInforms);
                    this.chopTree(pos, player, player.m_9236_(), stack, list1, energy, smelter, comb, mac, generator, random, black_list, list);
                    return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case TUNNEL: {
                if (block == Blocks.f_50016_) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                return this.break_block_tunel(world, block, mop, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case SHEARS: {
                if (block == Blocks.f_50016_) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                if (block.m_204297_().m_203656_(BlockTags.f_13035_)) {
                    return this.break_shears(world, block, mop, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        return false;
    }

    private boolean break_shears(Level world, Block block, BlockHitResult mop, Player player, BlockPos pos, ItemStack itemstack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean blackList, List<String> list) {
        float energy = this.energy(itemstack, upgradeItemInforms);
        BlockState state = world.m_8055_(pos);
        if (state.m_204336_(BlockTags.f_13035_) && ElectricItem.manager.use(itemstack, energy, (LivingEntity)player) && !block.equals(Blocks.f_50016_) && this.isCorrectToolForDrops(itemstack, state) && state.m_60800_((BlockGetter)world, pos) >= 0.0f && state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
            this.onBlockDestroyed(itemstack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, blackList, list, true);
            return true;
        }
        return false;
    }

    private boolean break_block_tunel(Level world, Block block, BlockHitResult mop, Player player, BlockPos pos, ItemStack stack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> list) {
        int xRange = 6;
        int yRange = 6;
        int zRange = 6;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        Direction direction = ItemEnergyInstruments.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82434_();
        switch (direction.ordinal()) {
            case 0: 
            case 1: {
                xRange = 0;
                zRange = 0;
                break;
            }
            case 2: 
            case 3: {
                xRange = 0;
                yRange = 0;
                break;
            }
            case 4: 
            case 5: {
                zRange = 0;
                yRange = 0;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
        CompoundTag nbt = ModUtils.nbt(stack);
        float energy = this.energy(stack, upgradeItemInforms);
        byte dig_depth = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0);
        if (dig_depth > 0) {
            if (zRange > 0) {
                xRange = dig_depth;
            } else {
                zRange = xRange > 0 ? (int)dig_depth : (int)dig_depth;
            }
        }
        boolean save = nbt.m_128471_("save");
        if (!player.m_7500_()) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block6: for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, energy)) {
                            BlockState state;
                            Block localBlock;
                            BlockPos pos_block = new BlockPos(xPos, yPos, zPos);
                            if (save && world.m_7702_(pos_block) != null || (localBlock = (state = world.m_8055_(pos_block)).m_60734_()).equals(Blocks.f_50016_) || !this.isCorrectToolForDrops(stack, state) || !(state.m_60800_((BlockGetter)world, pos_block) >= 0.0f)) continue;
                            if (state.m_60800_((BlockGetter)world, pos_block) >= 0.0f) {
                                this.onBlockDestroyed(stack, world, state, pos_block, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                            }
                            if (silktouch) continue;
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, fortune, stack, localBlock));
                            continue;
                        }
                        lowPower = true;
                        continue block6;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.m_8055_(pos);
            Block localBlock = state.m_60734_();
            if (!localBlock.equals(Blocks.f_50016_) && this.isCorrectToolForDrops(stack, state) && state.m_60800_((BlockGetter)world, pos) >= 0.0f || block == Blocks.f_50085_) {
                if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        if (lowPower && ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.m_8055_(pos);
            Block localBlock = state.m_60734_();
            if (!localBlock.equals(Blocks.f_50016_) && this.isCorrectToolForDrops(stack, state) && state.m_60800_((BlockGetter)world, pos) >= 0.0f || block == Blocks.f_50085_) {
                if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.m_60800_((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        return true;
    }

    private void ore_break(Level world, BlockPos pos, Player player, boolean silktouch, int fortune, boolean lowPower, ItemStack stack, Block block1, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, float energy, List<String> list) {
        CompoundTag NBTTagCompound = ModUtils.nbt(stack);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (int Xx = x - 2; Xx <= x + 2; ++Xx) {
            block1: for (int Yy = y - 2; Yy <= y + 2; ++Yy) {
                for (int Zz = z - 2; Zz <= z + 2; ++Zz) {
                    BlockPos pos_block;
                    BlockState state;
                    Block localBlock;
                    int ore = NBTTagCompound.m_128451_("ore");
                    if (ore >= 32 || !ModUtils.getore(localBlock = (state = world.m_8055_(pos_block = new BlockPos(Xx, Yy, Zz))).m_60734_(), block1)) continue;
                    if (ElectricItem.manager.canUse(stack, energy)) {
                        if (player.m_7500_()) continue block1;
                        if (state.m_60800_((BlockGetter)world, pos_block) >= 0.0f) {
                            this.onBlockDestroyed(stack, world, state, pos_block, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                        }
                        if (!silktouch) {
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, fortune, stack, localBlock));
                        }
                        NBTTagCompound.m_128405_("ore", ++ore);
                        this.ore_break(world, pos_block, player, silktouch, fortune, lowPower, stack, block1, smelter, comb, mac, generator, random, black_list, energy, list);
                        continue;
                    }
                    lowPower = true;
                    continue block1;
                }
            }
        }
    }

    private int getExperience(BlockState state, Level world, BlockPos pos_block, int fortune, ItemStack stack, Block localBlock) {
        int col = localBlock.getExpDrop(state, (LevelReader)world, world.f_46441_, pos_block, fortune, 0);
        col = (int)((double)col * (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.EXPERIENCE, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EXPERIENCE, (ItemStack)stack).number * 0.5 + 1.0 : 1.0));
        return col;
    }

    public boolean onBlockDestroyed(@Nonnull ItemStack stack, @Nonnull Level world, BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        return this.onBlockDestroyed(stack, world, state, pos, entity, energy, smelter, comb, mac, generator, random, black_list, blackList, false);
    }

    public boolean onBlockDestroyed(@Nonnull ItemStack stack, @Nonnull Level world, BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList, boolean shears) {
        Block block = state.m_60734_();
        if (block.equals(Blocks.f_50016_)) {
            return false;
        }
        if (state.m_60767_().m_76332_() || state.m_60734_().m_155943_() == 0.0f && !((Player)entity).m_7500_()) {
            return false;
        }
        if (!world.f_46443_) {
            int rand;
            if (ForgeHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)entity).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)entity), (BlockPos)pos) == -1) {
                return false;
            }
            if (block.onDestroyedByPlayer(state, world, pos, (Player)((ServerPlayer)entity), true, world.m_6425_(pos))) {
                block.m_6786_((LevelAccessor)world, pos, state);
                block.m_6240_(world, (Player)((ServerPlayer)entity), pos, state, null, stack);
                CompoundTag nbt = ModUtils.nbt(stack);
                List items = entity.m_9236_().m_45976_(ItemEntity.class, new AABB((double)(pos.m_123341_() - 1), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)));
                this.addExperience(stack, 1);
                if (!black_list || ModUtils.getore(block, block) && this.check_list(block, 0, blackList)) {
                    for (ItemEntity item : items) {
                        RecipeOutput rec;
                        if (entity.m_9236_().f_46443_) continue;
                        ItemStack stack1 = item.m_32055_();
                        if (comb) {
                            rec = Recipes.recipes.getRecipeOutput((String)"comb_macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output;
                            if (rec != null) {
                                stack1 = rec.items.get(0).m_41777_();
                                stack1.m_41764_(3);
                            }
                        } else if (mac && (rec = Recipes.recipes.getRecipeOutput((String)"macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output) != null) {
                            stack1 = rec.items.get(0).m_41777_();
                        }
                        ItemStack smelt = new ItemStack((ItemLike)Items.f_41852_);
                        if (smelter && !(smelt = ModUtils.getRecipeFromType(world, stack1, (RecipeType<SmeltingRecipe>)RecipeType.f_44108_)).m_41619_()) {
                            smelt.m_41764_(stack1.m_41613_());
                        }
                        if (generator) {
                            boolean rec2;
                            int fuel = ModUtils.getFuelValue(stack1, false);
                            boolean bl = rec2 = fuel > 0;
                            if (rec2) {
                                int amount = stack1.m_41613_();
                                int value = fuel / 4;
                                amount *= value;
                                amount = (int)((float)amount * 10.0f);
                                double sentPacket = ElectricItem.manager.charge(stack, amount, Integer.MAX_VALUE, true, false);
                                amount = (int)((double)amount - sentPacket);
                                amount = (int)((float)amount / ((float)value * 10.0f));
                                stack1.m_41764_(amount);
                            }
                        }
                        if (!smelt.m_41619_()) {
                            item.m_32045_(smelt);
                        } else {
                            item.m_32045_(stack1);
                        }
                        item.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.m_32010_(0);
                    }
                } else if (nbt.m_128471_("black")) {
                    for (ItemEntity item : items) {
                        if (entity.m_9236_().f_46443_) continue;
                        item.m_142687_(Entity.RemovalReason.KILLED);
                    }
                }
            }
            if (random != 0 && (rand = world.f_46441_.m_188503_(100001)) >= 100000 - random) {
                ItemEntity item = new ItemEntity(EntityType.f_20461_, world);
                item.m_32045_(IUCore.get_ingot.get(world.f_46441_.m_188503_(IUCore.get_ingot.size())));
                item.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0f, 0.0f);
                ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                item.m_32010_(0);
            }
        } else if (block.onDestroyedByPlayer(state, world, pos, (Player)entity, true, world.m_6425_(pos))) {
            block.m_6786_((LevelAccessor)world, pos, state);
        }
        if (entity.m_6084_() && energy != 0.0f) {
            ElectricItem.manager.use(stack, energy, entity);
        }
        return true;
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        return new ItemStackUpgradeItem(player, stack);
    }

    public boolean check_list(Block block, int metaFromState, List<String> blackList) {
        if (blackList.isEmpty()) {
            return true;
        }
        ItemStack stack1 = new ItemStack((ItemLike)block, 1);
        if (stack1.m_41619_()) {
            return true;
        }
        List list = stack1.m_204131_().toList();
        if (list.isEmpty()) {
            return true;
        }
        String name = ((TagKey)list.get(0)).f_203868_().toString();
        return !blackList.contains(name);
    }

    public void saveToolMode(ItemStack itemstack, int toolMode) {
        CompoundTag nbt = ModUtils.nbt(itemstack);
        nbt.m_128405_("toolMode", toolMode);
        itemstack.m_41751_(nbt);
    }

    public float energy(ItemStack stack, List<UpgradeItemInform> upgradeItemInforms) {
        int energy1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack, upgradeItemInforms).number : 0;
        int toolMode = this.readToolMode(stack);
        EnumOperations operations = this.operations.get(toolMode);
        float energy = switch (operations) {
            case EnumOperations.BIGHOLES -> (float)((double)this.energyBigHolePowerOperation - (double)this.energyBigHolePowerOperation * 0.25 * (double)energy1);
            case EnumOperations.MEGAHOLES -> (float)((double)this.energyPerbigHolePowerOperation - (double)this.energyPerbigHolePowerOperation * 0.25 * (double)energy1);
            case EnumOperations.ULTRAHOLES -> (float)((double)this.energyPerultraLowPowerOperation - (double)this.energyPerultraLowPowerOperation * 0.25 * (double)energy1);
            default -> (float)((double)this.energyPerOperation - (double)this.energyPerOperation * 0.25 * (double)energy1);
        };
        return energy;
    }

    public InteractionResult m_6225_(UseOnContext p_41427_) {
        Player player = p_41427_.m_43723_();
        if (this.toolType.contains("pickaxe")) {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                boolean result;
                Item item;
                ItemStack torchStack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (torchStack.m_41619_() || !torchStack.m_150930_(Items.f_42000_) || !((item = torchStack.m_41720_()) instanceof BlockItem)) continue;
                UseOnContext useOnContext = new UseOnContext(p_41427_.m_43725_(), p_41427_.m_43723_(), p_41427_.m_43724_(), torchStack, new BlockHitResult(p_41427_.m_43720_(), p_41427_.m_43719_(), p_41427_.m_8083_(), p_41427_.m_43721_()));
                boolean bl = result = torchStack.m_41720_().m_6225_(useOnContext) == InteractionResult.SUCCESS;
                if (!result) continue;
                torchStack.m_41764_(torchStack.m_41613_() - 1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public List<EnumOperations> getOperations() {
        return this.operations;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return this.type.getEnumInfoUpgradeModules();
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(stack);
        String[] mode = new String[]{"", "Zelen", "Demon", "Dark", "Cold", "Ender", "Ukraine", "Fire", "Snow", "Taiga", "Desert", "Emerald"};
        for (int i = 0; i < mode.length; ++i) {
            if (!nbt.m_128461_("mode").equals(mode[i])) continue;
            return i;
        }
        return 0.0f;
    }
}

