/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.api.item.IEnergyItem;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InputItemStack
implements IInputItemStack {
    public static InputItemStack EMPTY = new InputItemStack(ItemStack.f_41583_, 1, true);
    public final ItemStack input;
    public int amount;

    public static IInputItemStack create(CompoundTag tag) {
        byte id = tag.m_128445_("id");
        if (id == 0) {
            return new InputItemStack(tag);
        }
        if (id == 1) {
            return new InputOreDict(tag);
        }
        return new InputFluidStack(tag);
    }

    public InputItemStack(ItemStack input) {
        this(input, ModUtils.getSize(input));
    }

    public InputItemStack(ItemStack input, int amount) {
        if (ModUtils.isEmpty(input)) {
            throw new IllegalArgumentException("invalid input stack");
        }
        this.input = input.m_41777_();
        this.amount = amount;
    }

    public InputItemStack(CompoundTag compoundTag) {
        boolean exist = compoundTag.m_128471_("exist");
        if (exist) {
            this.input = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("input"));
            this.amount = compoundTag.m_128451_("amount");
        } else {
            this.input = ItemStack.f_41583_;
            this.amount = 1;
        }
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128344_("id", (byte)0);
        compoundTag.m_128379_("exist", this.input != null && !this.input.m_41619_());
        if (this.input != null && !this.input.m_41619_()) {
            compoundTag.m_128405_("amount", this.amount);
            compoundTag.m_128365_("input", (Tag)this.input.m_41739_(new CompoundTag()));
        }
        return compoundTag;
    }

    InputItemStack(ItemStack input, int amount, boolean f) {
        this.input = input.m_41777_();
        this.amount = amount;
    }

    @Override
    public void growAmount(int col) {
        ++this.amount;
        this.input.m_41764_(this.amount);
    }

    @Override
    public boolean matches(ItemStack subject) {
        boolean energy = this.input.m_41720_() instanceof IEnergyItem && subject.m_41720_() instanceof IEnergyItem;
        return subject.m_41720_() == this.input.m_41720_() && ModUtils.checkItemEquality(this.input, subject);
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.singletonList(ModUtils.setSize(this.input, this.getAmount()));
    }

    @Override
    public boolean hasTag() {
        return false;
    }

    @Override
    public TagKey<Item> getTag() {
        return null;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeInt(0);
        buffer.m_130055_(this.input);
    }

    public String toString() {
        return "RInputItemStack<" + ModUtils.setSize(this.input, this.amount) + ">";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (this.getClass() != obj.getClass()) return false;
        InputItemStack other = (InputItemStack)obj;
        if (!ModUtils.checkItemEqualityStrict(other.input, this.input)) return false;
        if (other.amount != this.amount) return false;
        return true;
    }
}

