/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyController;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.Path;
import com.denfop.api.energy.event.EventLoadController;
import com.denfop.api.energy.event.EventUnloadController;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerController;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiEnergyController;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TileEnergyController
extends TileEntityInventory
implements IUpdatableTileEvent,
IEnergyController {
    public List<Path> energyPathList = new ArrayList<Path>();
    public boolean work = false;
    public int size;
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    int hashCodeSource;
    private ChunkPos chunkPos;
    private long id;

    public TileEnergyController(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.energy_controller, pos, state);
        this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 0.0, 14));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.energy_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.controller.info"));
        tooltip.add(Localization.translate("iu.controller.info1"));
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.size = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadController(this, this.f_58857_));
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnloadController(this, this.f_58857_));
        }
        super.onUnloaded();
    }

    public ContainerController getGuiContainer(Player entityPlayer) {
        return new ContainerController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiEnergyController((ContainerController)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128379_("work", this.work);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.work = nbtTagCompound.m_128471_("work");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (i == 0.0) {
            this.energyPathList.clear();
            for (Direction facing : Direction.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.getWorld(), this.m_58899_().m_121955_(facing.m_122436_()));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.size = this.energyPathList.size();
        } else if (i == 1.0) {
            this.work = true;
            this.energyPathList.forEach(energyPath -> energyPath.setHasController(true));
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.energyPathList.clear();
            for (Direction facing : Direction.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.getWorld(), this.m_58899_().m_121955_(facing.m_122436_()));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.size = this.energyPathList.size();
            this.energyPathList.forEach(energyPath -> energyPath.setHasController(true));
        }
    }

    @Override
    public void unload() {
        this.energyPathList.forEach(energyPath -> energyPath.setHasController(false));
    }
}

