/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.things.fluid;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerLavaGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiLavaGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ParticleUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileLavaGenerator
extends TileElectricMachine
implements IUpgradableBlock {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public final InvSlotFluid containerslot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, new Fluid[]{net.minecraft.world.level.material.Fluids.f_76195_});
    public final FluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final float energycost;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private double lastEnergy;

    public TileLavaGenerator(BlockPos pos, BlockState state) {
        super(20000.0, 1, 1, BlockBaseMachine2.lava_gen, pos, state);
        this.energycost = 80.0f;
        this.fluidTank = this.fluids.addTank("fluidTank", 20000, InvSlot.TypeItemSlot.OUTPUT, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.f_76195_}));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.15));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.3));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.lava_gen;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.lastEnergy = nbt.m_128459_("lastEnergy");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128347_("lastEnergy", this.lastEnergy);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.setUpgradestat();
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.gen_lava.getSoundEvent();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.m_58904_().m_46467_() % 5L == 0L) {
            ParticleUtils.spawnLavaGeneratorParticles(this.m_58904_(), this.pos, this.m_58904_().f_46441_);
        }
        boolean needsInvUpdate = false;
        if (!(this.energy.getEnergy() <= 0.0) && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            if (this.energy.getEnergy() >= (double)this.energycost) {
                needsInvUpdate = this.attemptGeneration();
                this.setActive(true);
                if (this.m_58904_().m_46467_() % 40L == 0L) {
                    this.initiate(0);
                }
            } else if (this.m_58904_().m_46467_() % 40L == 0L) {
                this.initiate(2);
            }
            this.lastEnergy = this.energy.getEnergy();
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (!this.containerslot.isEmpty() && this.fluidTank.getFluidAmount() > 0) {
            this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fill(new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76195_, Math.min(m, k)), IFluidHandler.FluidAction.EXECUTE);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
        return true;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return p + "%";
    }

    public ContainerLavaGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerLavaGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiLavaGenerator((ContainerLavaGenerator)isAdmin);
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileLavaGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.FluidExtract);
    }
}

