/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSteamPump;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSteamPump;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSteamPump
extends TileElectricLiquidTankInventory {
    public final int defaultTier;
    public final double defaultEnergyStorage = this.operationLength;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final PressureComponent pressure;
    public final ComponentSteamEnergy steam;
    private final Fluids.InternalFluidTank fluidTank1;
    public double energyConsume = 2.0;
    public int operationsPerTick;
    public int operationLength = 25;
    public ComponentProgress componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, (short)this.operationLength));

    public TileSteamPump(BlockPos pos, BlockState state) {
        super(0.0, 1, 10, BlockBaseMachine3.steam_pump, pos, state);
        this.defaultEnergyConsume = 2.0;
        this.defaultOperationLength = 25;
        this.defaultTier = 1;
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
        this.fluidTank1 = this.fluids.addTank("fluidTank2", 4000, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()), InvSlot.TypeItemSlot.NONE);
        this.pressure = this.addComponent(PressureComponent.asBasicSink(this, 1.0));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank1);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.steam_pump;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.steam.canUseEnergy(this.energyConsume)) {
            if (this.componentProgress.getProgress() < this.componentProgress.getMaxValue()) {
                this.componentProgress.addProgress(0);
                this.steam.useEnergy(this.energyConsume);
            } else if (this.canoperate()) {
                this.componentProgress.setProgress((short)0);
            }
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        FluidStack liquid = FluidStack.EMPTY;
        boolean canOperate = false;
        for (int i = this.pos.m_123341_() - 1; i <= this.pos.m_123341_() + 1; ++i) {
            for (int j = this.pos.m_123343_() - 1; j <= this.pos.m_123343_() + 1; ++j) {
                for (int k = this.pos.m_123342_() - 3; k <= this.pos.m_123342_() - 1; ++k) {
                    if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
                        return false;
                    }
                    liquid = this.pump(new BlockPos(i, k, j), false);
                    if (this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                    this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.EXECUTE);
                    canOperate = true;
                }
            }
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        BlockState block;
        FluidStack ret = FluidStack.EMPTY;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.getWorld().m_8055_(pos)).m_60767_().m_76332_()) {
            FluidState fluidState = block.m_60734_().m_5888_(block);
            if (!fluidState.m_76170_()) {
                return FluidStack.EMPTY;
            }
            ret = new FluidStack(fluidState.m_76152_(), 1000);
            if ((this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == ret.getFluid()) && !sim) {
                this.getWorld().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    public ContainerSteamPump getGuiContainer(Player entityPlayer) {
        return new ContainerSteamPump(entityPlayer, this);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSteamPump((ContainerSteamPump)menu);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

