/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.world.WorldBaseGen;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;

public class WorldGenOil
extends Feature<NoneFeatureConfiguration> {
    private BlockState spreadBlock;
    final FluidName[] fluids = new FluidName[]{FluidName.fluidneft, FluidName.fluidsweet_medium_oil, FluidName.fluidsweet_heavy_oil, FluidName.fluidsour_light_oil, FluidName.fluidsour_medium_oil, FluidName.fluidsour_heavy_oil};

    public WorldGenOil(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int k;
        int j;
        if (WorldBaseGen.random.nextInt(100) + 1 <= 90) {
            return false;
        }
        FluidName fluidName = this.fluids[context.m_225041_().m_188503_(this.fluids.length)];
        this.spreadBlock = ((IUFluid)((Object)fluidName.getInstance().get())).m_5613_().m_76145_().m_76188_();
        BlockPos pos = context.m_159777_();
        int y = context.m_159774_().m_6924_(Heightmap.Types.WORLD_SURFACE_WG, context.m_159777_().m_123341_(), context.m_159777_().m_123343_());
        Holder holder = context.m_159774_().m_204166_(new BlockPos(context.m_159777_().m_123341_(), y, context.m_159777_().m_123343_()));
        if (!holder.m_203656_(Tags.Biomes.IS_DESERT)) {
            return false;
        }
        RandomSource rand = context.m_225041_();
        WorldGenLevel world = context.m_159774_();
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        y = context.m_225041_().m_188503_(context.m_225041_().m_188503_(context.m_225041_().m_188503_(112) + 8) + 8) + 60;
        BlockState block_state = world.m_8055_(pos);
        while (y > 40 && block_state.m_60795_()) {
            block_state = world.m_8055_(new BlockPos(x, --y, z));
        }
        if (y <= 40) {
            return false;
        }
        y -= 4;
        boolean[] arrayOfBoolean = new boolean[2048];
        int i = rand.m_188503_(4) + 4;
        for (int j2 = 0; j2 < i; ++j2) {
            double d1 = rand.m_188500_() * 6.0 + 3.0;
            double d2 = rand.m_188500_() * 4.0 + 2.0;
            double d3 = rand.m_188500_() * 6.0 + 3.0;
            double d4 = rand.m_188500_() * (16.0 - d1 - 2.0) + 1.0 + d1 / 2.0;
            double d5 = rand.m_188500_() * (8.0 - d2 - 4.0) + 2.0 + d2 / 2.0;
            double d6 = rand.m_188500_() * (16.0 - d3 - 2.0) + 1.0 + d3 / 2.0;
            for (int i2 = 1; i2 < 15; ++i2) {
                for (int i3 = 1; i3 < 15; ++i3) {
                    for (int i4 = 1; i4 < 7; ++i4) {
                        double d7 = ((double)i2 - d4) / (d1 / 2.0);
                        double d8 = ((double)i4 - d5) / (d2 / 2.0);
                        double d9 = ((double)i3 - d6) / (d3 / 2.0);
                        double d10 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (!(d10 < 1.0)) continue;
                        arrayOfBoolean[(i2 * 16 + i3) * 8 + i4] = true;
                    }
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 0; m < 8; ++m) {
                    boolean n;
                    int i1 = (j * 16 + k) * 8 + m;
                    boolean bl = n = arrayOfBoolean[i1] && (j < 15 && arrayOfBoolean[((j + 1) * 16 + k) * 8 + m] || j > 0 && arrayOfBoolean[((j - 1) * 16 + k) * 8 + m] || k < 15 && arrayOfBoolean[(j * 16 + k + 1) * 8 + m] || k > 0 && arrayOfBoolean[(j * 16 + k - 1) * 8 + m] || m < 7 && arrayOfBoolean[(j * 16 + k) * 8 + m + 1] || m > 0 && arrayOfBoolean[i1 - 1]);
                    if (!n) continue;
                    BlockState block_state1 = world.m_8055_(new BlockPos(x + j, y + m, z + k));
                    Material material = block_state1.m_60767_();
                    if (m >= 4 && material.m_76332_()) {
                        return false;
                    }
                    if (m >= 4 || material.m_76333_() || block_state1.m_60734_() == this.spreadBlock.m_60734_()) continue;
                    return false;
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 0; m < 8; ++m) {
                    boolean need = arrayOfBoolean[(j * 16 + k) * 8 + m];
                    if (need) {
                        world.m_7731_(new BlockPos(x + j, y + m, z + k), m >= 4 ? Blocks.f_50016_.m_49966_() : this.spreadBlock, 2);
                    }
                    if (m < 4) continue;
                    BlockState block_states = null;
                    if (need) {
                        block_states = world.m_8055_(new BlockPos(x + j, y + m - 1, z + k));
                    }
                    if (!need || block_states.m_60734_() != Blocks.f_50493_ && block_states.m_60734_() != Blocks.f_49990_ || world.m_45517_(LightLayer.SKY, new BlockPos(x + k, y + m - 1, z + k)) <= 0) continue;
                    world.m_7731_(new BlockPos(x + j, y + m - 1, z + k), Blocks.f_50034_.m_49966_(), 2);
                }
            }
        }
        return true;
    }
}

