/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein;

import com.denfop.IUItem;
import com.denfop.blocks.BlockDeposits;
import com.denfop.blocks.BlockDeposits1;
import com.denfop.blocks.BlockDeposits2;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinStructure;
import com.denfop.world.vein.VeinType;
import com.denfop.world.vein.noise.PerlinNoiseViewer;
import com.denfop.world.vein.noise.Point;
import com.denfop.world.vein.noise.ShellCluster;
import com.mojang.serialization.Codec;
import java.awt.Color;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public class AlgorithmVein
extends Feature<NoneFeatureConfiguration> {
    public static List<VeinStructure> veinStructureList = new LinkedList<VeinStructure>();
    static Random random = new Random();
    private static Map<ChunkPos, ChunkAccess> chunkPosChunkMap = new HashMap<ChunkPos, ChunkAccess>();
    private static List<ShellCluster> shellClusterList = new ArrayList<ShellCluster>();
    public static ShellCluster volcano;
    public static Map<Integer, Map<Integer, Tuple<Color, Integer>>> shellClusterChuncks;

    public AlgorithmVein(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private static boolean generate(WorldGenLevel level, VeinType veinType, BlockPos blockPos, ChunkAccess chunk, int meta1, Color color) {
        block124: {
            block125: {
                BlockPos pos1;
                int chance_type;
                block123: {
                    int k;
                    int height2 = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_());
                    Holder biome = level.m_204166_(new BlockPos(blockPos.m_123341_(), height2, blockPos.m_123343_()));
                    if (color == Color.LIGHT_GRAY) {
                        veinType.setVein(TypeVein.SMALL);
                    } else if (color == Color.GRAY) {
                        veinType.setVein(TypeVein.MEDIUM);
                    } else if (color == Color.BLACK) {
                        veinType.setVein(TypeVein.BIG);
                    }
                    chance_type = random.nextInt(101);
                    if (chance_type > 15 || !biome.m_203656_(BiomeTags.f_207608_)) break block123;
                    ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
                    int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_());
                    int radius = 10;
                    if (veinType.getVein() == TypeVein.SMALL) {
                        radius = level.m_213780_().m_188503_(4) + 2;
                    } else if (veinType.getVein() == TypeVein.MEDIUM) {
                        radius = level.m_213780_().m_188503_(6) + 3;
                    } else if (veinType.getVein() == TypeVein.BIG) {
                        radius = level.m_213780_().m_188503_(7) + 5;
                    }
                    BlockPos pos = new BlockPos(blockPos.m_123341_(), (int)((double)height - (double)radius * 0.9 - (double)random.nextInt(35)), blockPos.m_123343_());
                    ChunkPos chunkPos = null;
                    ChunkAccess chunk1 = null;
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                double distance = Math.sqrt(x * x + y * y + z * z);
                                if (distance <= (double)radius && distance > (double)radius * 0.45) {
                                    int meta = random.nextInt(veinType.getOres().size());
                                    ChanceOre ore = veinType.getOres().get(meta);
                                    BlockPos pos12 = pos.m_7918_(x, y, z);
                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = level.m_6522_(pos12.m_123341_() >> 4, pos12.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    } else if (pos12.m_123341_() >> 4 != chunkPos.f_45578_ && pos12.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                        chunk1 = level.m_6522_(pos12.m_123341_() >> 4, pos12.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    }
                                    if (!AlgorithmVein.canGenerateSphere(level, pos12, chunk1)) continue;
                                    blockPosList.add(pos12);
                                    AlgorithmVein.setBlockState1(level, pos12, ore.getBlock(), 2, chunk1);
                                    continue;
                                }
                                if (distance <= (double)radius && distance >= (double)radius * 0.35) {
                                    BlockPos pos13 = pos.m_7918_(x, y, z);
                                    if (veinType.getHeavyOre() != null) {
                                        if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerateSphere(level, pos13, chunk1)) continue;
                                        blockPosList.add(pos13);
                                        AlgorithmVein.setBlockState1(level, pos13, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2, chunk1);
                                        continue;
                                    }
                                    int meta = random.nextInt(veinType.getOres().size());
                                    ChanceOre ore = veinType.getOres().get(meta);
                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = level.m_6522_(pos13.m_123341_() >> 4, pos13.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    } else if (pos13.m_123341_() >> 4 != chunkPos.f_45578_ && pos13.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                        chunk1 = level.m_6522_(pos13.m_123341_() >> 4, pos13.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.m_7697_();
                                    }
                                    if (!AlgorithmVein.canGenerateSphere(level, pos13, chunk1)) continue;
                                    blockPosList.add(pos13);
                                    AlgorithmVein.setBlockState1(level, pos13, ore.getBlock(), 2, chunk1);
                                    continue;
                                }
                                if (!(distance <= (double)radius) || !(distance < (double)radius * 0.35)) continue;
                                BlockPos pos14 = pos.m_7918_(x, y, z);
                                chunk1 = level.m_6522_(pos14.m_123341_() >> 4, pos14.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                AlgorithmVein.setBlockState1(level, pos14, Blocks.f_50016_.m_49966_(), 2, chunk1);
                            }
                        }
                    }
                    int ii = 0;
                    switch (veinType.getVein()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case SMALL: {
                            int n = 5;
                            break;
                        }
                        case MEDIUM: {
                            int n = 10;
                            break;
                        }
                        case BIG: {
                            int n = k = 15;
                        }
                    }
                    while (ii < k && !blockPosList.isEmpty()) {
                        int y;
                        BlockPos pos15 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                        if (chunk1 == null) {
                            chunk1 = level.m_6522_(pos15.m_123341_() >> 4, pos15.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            chunkPos = chunk1.m_7697_();
                        } else if (pos15.m_123341_() >> 4 != chunkPos.f_45578_ && pos15.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                            chunk1 = level.m_6522_(pos15.m_123341_() >> 4, pos15.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            chunkPos = chunk1.m_7697_();
                        }
                        int height1 = y = chunk1.m_5885_(Heightmap.Types.WORLD_SURFACE, pos15.m_123341_(), pos15.m_123343_());
                        BlockPos pos2 = null;
                        boolean need = false;
                        while (height1 - 3 < y) {
                            pos2 = new BlockPos(pos15.m_123341_(), y - 1, pos15.m_123343_());
                            BlockState oldState = level.m_8055_(pos2);
                            pos2 = new BlockPos(pos15.m_123341_(), y + 1, pos15.m_123343_());
                            BlockState upState = level.m_8055_(pos2);
                            pos2 = new BlockPos(pos15.m_123341_(), y, pos15.m_123343_());
                            BlockState oldState1 = level.m_8055_(pos2);
                            boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                            if (canSpawn) {
                                need = true;
                                break;
                            }
                            --y;
                        }
                        blockPosList.remove(pos15);
                        if (!need) continue;
                        FluidState fluidState = level.m_6425_(pos2);
                        if (meta1 < 16) {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                        } else if (meta1 < 32) {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                        } else {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                        }
                        ++ii;
                    }
                    break block124;
                }
                if (chance_type > 80) break block125;
                AbstractList blockPosList = new LinkedList<BlockPos>();
                int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_());
                BlockPos pos = new BlockPos(blockPos.m_123341_(), height / 2 + height / 4, blockPos.m_123343_());
                int x1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int y1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int z1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int minX = 10;
                int minY = 10;
                int minZ = 10;
                int maxX = -10;
                int maxY = -10;
                int maxZ = -10;
                ChunkPos chunkPos = null;
                ChunkAccess chunk1 = null;
                for (int x = -x1; x < x1 + 1; ++x) {
                    for (int y = -y1; y < y1; ++y) {
                        for (int z = -z1; z < z1 + 1; ++z) {
                            int meta = random.nextInt(veinType.getOres().size());
                            ChanceOre ore = veinType.getOres().get(meta);
                            int need = Math.max(Math.max(x, y), z);
                            if (need < veinType.getVein().getMinNeed()) {
                                need = 0;
                            }
                            BlockPos pos16 = pos.m_7918_(x, y, z);
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = level.m_6522_(pos16.m_123341_() >> 4, pos16.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            } else if (pos16.m_123341_() >> 4 != chunkPos.f_45578_ && pos16.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                chunk1 = level.m_6522_(pos16.m_123341_() >> 4, pos16.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            }
                            if (random.nextInt(50) > 10 && ore.needGenerate(level) && (need == 0 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) > 50) && AlgorithmVein.canGenerate(level, pos16, chunk1)) {
                                if (x < minX) {
                                    minX = x;
                                }
                                if (x > maxX) {
                                    maxX = x;
                                }
                                if (y < minY) {
                                    minY = y;
                                }
                                if (y > maxY) {
                                    maxY = y;
                                }
                                if (z < minZ) {
                                    minZ = z;
                                }
                                if (z > maxZ) {
                                    maxZ = z;
                                }
                                blockPosList.add(pos16);
                                AlgorithmVein.setBlockState1(level, pos16, ore.getBlock(), 2, chunk1);
                                continue;
                            }
                            if (veinType.getHeavyOre() == null || random.nextInt(50) <= 40 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) <= 50 || !AlgorithmVein.canGenerate(level, pos16, chunk1)) continue;
                            blockPosList.add(pos16);
                            AlgorithmVein.setBlockState1(level, pos16, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2, chunk1);
                            if (x < minX) {
                                minX = x;
                            }
                            if (x > maxX) {
                                maxX = x;
                            }
                            if (y < minY) {
                                minY = y;
                            }
                            if (y > maxY) {
                                maxY = y;
                            }
                            if (z < minZ) {
                                minZ = z;
                            }
                            if (z <= maxZ) continue;
                            maxZ = z;
                        }
                    }
                }
                int[] numbers = new int[]{maxY, minY, maxX, minX, maxZ, minZ};
                int[] number2 = new int[]{1, 0, 3, 2, 5, 4};
                int[] yxz = new int[]{0, 0, 0};
                int[][] yxz1 = new int[][]{{1, 2}, {0, 2}, {0, 1}};
                int[][] numbers1 = new int[][]{{3, 2, 5, 4}, {1, 0, 5, 4}, {1, 0, 3, 2}};
                chunk1 = null;
                chunkPos = null;
                int level1 = 1;
                int i = random.nextInt(6);
                while (level1 < veinType.getVein().getLevel() + 1) {
                    block130: {
                        ChanceOre ore;
                        int meta;
                        block126: {
                            if (i % 2 != 0) break block126;
                            yxz[i / 2] = numbers[i];
                            while (yxz[i / 2] < random.nextInt(veinType.getVein().getMax_length()) + 3 + numbers[i] + 1) {
                                yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level1 * 2;
                                while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level1 * 2 + 1) {
                                    yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level1 * 2;
                                    while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level1 * 2 + 1) {
                                        block127: {
                                            block129: {
                                                block128: {
                                                    meta = random.nextInt(veinType.getOres().size());
                                                    ore = veinType.getOres().get(meta);
                                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) break block127;
                                                    pos1 = pos.m_7918_(yxz[1], yxz[0], yxz[2]);
                                                    if (chunk1 != null && chunkPos != null) break block128;
                                                    chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                                    if (chunk1 == null) break block127;
                                                    chunkPos = chunk1.m_7697_();
                                                    break block129;
                                                }
                                                if (pos1.m_123341_() >> 4 == chunkPos.f_45578_ || pos1.m_123343_() >> 4 == chunk.m_7697_().f_45579_) break block129;
                                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                                if (chunk1 == null) break block127;
                                                chunkPos = chunk1.m_7697_();
                                            }
                                            if (AlgorithmVein.canGenerate(level, pos1, chunk1)) {
                                                blockPosList.add(pos1);
                                                AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                                            }
                                        }
                                        int n = yxz1[i / 2][1];
                                        yxz[n] = yxz[n] + 1;
                                    }
                                    int n = yxz1[i / 2][0];
                                    yxz[n] = yxz[n] + 1;
                                }
                                int n = i / 2;
                                yxz[n] = yxz[n] + 1;
                            }
                            break block130;
                        }
                        yxz[i / 2] = numbers[i];
                        while (yxz[i / 2] > numbers[i] - random.nextInt(veinType.getVein().getMax_length()) - 4) {
                            yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level1 * 2;
                            while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level1 * 2 + 1) {
                                yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level1 * 2;
                                while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level1 * 2 + 1) {
                                    block131: {
                                        block133: {
                                            block132: {
                                                meta = random.nextInt(veinType.getOres().size());
                                                ore = veinType.getOres().get(meta);
                                                if (!ore.needGenerate(level) || random.nextInt(100) <= 50) break block131;
                                                pos1 = pos.m_7918_(yxz[1], yxz[0], yxz[2]);
                                                if (chunk1 != null && chunkPos != null) break block132;
                                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                                if (chunk1 == null) break block131;
                                                chunkPos = chunk1.m_7697_();
                                                break block133;
                                            }
                                            if (pos1.m_123341_() >> 4 == chunkPos.f_45578_ || pos1.m_123343_() >> 4 == chunk.m_7697_().f_45579_) break block133;
                                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                            if (chunk1 == null) break block131;
                                            chunkPos = chunk1.m_7697_();
                                        }
                                        if (AlgorithmVein.canGenerate(level, pos1, chunk1)) {
                                            blockPosList.add(pos1);
                                            AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                                        }
                                    }
                                    int n = yxz1[i / 2][1];
                                    yxz[n] = yxz[n] + 1;
                                }
                                int n = yxz1[i / 2][0];
                                yxz[n] = yxz[n] + 1;
                            }
                            int n = i / 2;
                            yxz[n] = yxz[n] - 1;
                        }
                    }
                    int n = number2[i];
                    numbers[n] = numbers[n] + (yxz[i / 2] - numbers[i]);
                    numbers[i] = yxz[i / 2];
                    ++level1;
                    int prev = i;
                    random.nextInt();
                    i = random.nextInt(6);
                    while (i != prev) {
                        i = random.nextInt(6);
                    }
                }
                int k = 0;
                switch (veinType.getVein()) {
                    case SMALL: {
                        k = 5;
                        break;
                    }
                    case MEDIUM: {
                        k = 10;
                        break;
                    }
                    case BIG: {
                        k = 15;
                    }
                }
                chunk1 = null;
                int ii = 0;
                blockPosList = new ArrayList(blockPosList);
                while (ii < k && !blockPosList.isEmpty()) {
                    int y;
                    pos1 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                    if (chunk1 == null) {
                        chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                        if (chunk1 == null) {
                            ++i;
                            continue;
                        }
                        chunkPos = chunk1.m_7697_();
                    } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                        chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                        if (chunk1 == null) {
                            ++i;
                            continue;
                        }
                        chunkPos = chunk1.m_7697_();
                    }
                    int height1 = y = chunk1.m_5885_(Heightmap.Types.WORLD_SURFACE, pos1.m_123341_(), pos1.m_123343_());
                    BlockPos pos2 = null;
                    boolean need = false;
                    while (height1 - 3 < y) {
                        pos2 = new BlockPos(pos1.m_123341_(), y - 1, pos1.m_123343_());
                        BlockState oldState = level.m_8055_(pos2);
                        pos2 = new BlockPos(pos1.m_123341_(), y + 1, pos1.m_123343_());
                        BlockState upState = level.m_8055_(pos2);
                        pos2 = new BlockPos(pos1.m_123341_(), y, pos1.m_123343_());
                        BlockState oldState1 = level.m_8055_(pos2);
                        boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                        if (canSpawn) {
                            need = true;
                            break;
                        }
                        --y;
                    }
                    blockPosList.remove(pos1);
                    if (!need) continue;
                    FluidState fluidState = level.m_6425_(pos2);
                    if (meta1 < 16) {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                    } else if (meta1 < 32) {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                    } else {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                    }
                    ++ii;
                }
                break block124;
            }
            int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_());
            BlockPos pos = new BlockPos(blockPos.m_123341_(), height / 2 + height / 4, blockPos.m_123343_());
            int centerX = pos.m_123341_();
            int centerY = pos.m_123342_();
            int centerZ = pos.m_123343_();
            int R = 0;
            int r = 0;
            int y1 = 0;
            if (veinType.getVein() == TypeVein.SMALL) {
                R = level.m_213780_().m_188503_(4) + 3;
                r = level.m_213780_().m_188503_(3) + 2;
                y1 = level.m_213780_().m_188503_(3) + 1;
            } else if (veinType.getVein() == TypeVein.MEDIUM) {
                R = level.m_213780_().m_188503_(6) + 3;
                r = level.m_213780_().m_188503_(4) + 3;
                y1 = level.m_213780_().m_188503_(3) + 2;
            } else if (veinType.getVein() == TypeVein.BIG) {
                R = level.m_213780_().m_188503_(7) + 5;
                r = level.m_213780_().m_188503_(4) + 4;
                y1 = level.m_213780_().m_188503_(5) + 3;
            }
            AbstractList blockPosList = new LinkedList();
            ChunkPos chunkPos = null;
            ChunkAccess chunk1 = null;
            for (int y2 = centerY - y1; y2 < centerY + y1; ++y2) {
                for (int x = -(R + r); x <= R + r; ++x) {
                    for (int z = -(R + r); z <= R + r; ++z) {
                        ChanceOre ore;
                        int meta;
                        BlockPos pos1;
                        if (x * x + z * z <= (R + r) * (R + r) && x * x + z * z > r * r) {
                            pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                            meta = random.nextInt(veinType.getOres().size());
                            ore = veinType.getOres().get(meta);
                            if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                                chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.m_7697_();
                            }
                            if (!AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                            blockPosList.add(pos1);
                            AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                            continue;
                        }
                        if (x * x + z * z > (R + r) * (R + r) || x * x + z * z < r * r) continue;
                        pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        }
                        if (veinType.getHeavyOre() != null) {
                            if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                            blockPosList.add(pos1);
                            AlgorithmVein.setBlockState1(level, pos1, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2, chunk1);
                            continue;
                        }
                        meta = random.nextInt(veinType.getOres().size());
                        ore = veinType.getOres().get(meta);
                        if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                            chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.m_7697_();
                        }
                        if (!AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                        blockPosList.add(pos1);
                        AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                    }
                }
            }
            chunk1 = null;
            int ii = 0;
            int k = 0;
            switch (veinType.getVein()) {
                case SMALL: {
                    k = 5;
                    break;
                }
                case MEDIUM: {
                    k = 10;
                    break;
                }
                case BIG: {
                    k = 15;
                }
            }
            blockPosList = new ArrayList(blockPosList);
            while (ii < k && !blockPosList.isEmpty()) {
                int y;
                BlockPos pos1 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                if (chunk1 == null) {
                    chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                    chunkPos = chunk1.m_7697_();
                } else if (pos1.m_123341_() >> 4 != chunkPos.f_45578_ && pos1.m_123343_() >> 4 != chunk.m_7697_().f_45579_) {
                    chunk1 = level.m_6522_(pos1.m_123341_() >> 4, pos1.m_123343_() >> 4, ChunkStatus.f_62314_, false);
                    chunkPos = chunk1.m_7697_();
                }
                int height1 = y = chunk1.m_5885_(Heightmap.Types.WORLD_SURFACE, pos1.m_123341_(), pos1.m_123343_());
                BlockPos pos2 = null;
                boolean need = false;
                while (height1 - 3 < y) {
                    pos2 = new BlockPos(pos1.m_123341_(), y - 1, pos1.m_123343_());
                    BlockState oldState = level.m_8055_(pos2);
                    pos2 = new BlockPos(pos1.m_123341_(), y + 1, pos1.m_123343_());
                    BlockState upState = level.m_8055_(pos2);
                    pos2 = new BlockPos(pos1.m_123341_(), y, pos1.m_123343_());
                    BlockState oldState1 = level.m_8055_(pos2);
                    boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                    if (canSpawn) {
                        need = true;
                        break;
                    }
                    --y;
                }
                blockPosList.remove(pos1);
                if (!need) continue;
                FluidState fluidState = level.m_6425_(pos2);
                if (meta1 < 16) {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                } else if (meta1 < 32) {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                } else {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).m_49966_().m_61124_((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.f_76191_.m_76145_() && fluidState.m_76152_() == Fluids.f_76193_)), 3, chunk1);
                }
                ++ii;
            }
        }
        chunkPosChunkMap.clear();
        return true;
    }

    public static void setBlockState1(WorldGenLevel level, BlockPos pPos, BlockState pState, int p_46607_, ChunkAccess access) {
        int l;
        int k;
        int j;
        BlockState blockstate;
        int i = pPos.m_123342_();
        LevelChunkSection levelchunksection = access.m_183278_(access.m_151564_(i));
        boolean flag = levelchunksection.m_188008_();
        if (!(flag && pState.m_60795_() || (blockstate = levelchunksection.m_62986_(j = pPos.m_123341_() & 0xF, k = i & 0xF, l = pPos.m_123343_() & 0xF, pState)) == pState)) {
            Block block = pState.m_60734_();
            access.m_6890_().forEach(entry -> {
                switch ((Heightmap.Types)entry.getKey()) {
                    case WORLD_SURFACE: {
                        ((Heightmap)entry.getValue()).m_64249_(j, i, l, pState);
                        break;
                    }
                    case MOTION_BLOCKING: {
                        ((Heightmap)entry.getValue()).m_64249_(j, i, l, pState);
                        break;
                    }
                    case MOTION_BLOCKING_NO_LEAVES: {
                        ((Heightmap)entry.getValue()).m_64249_(j, i, l, pState);
                        break;
                    }
                    case OCEAN_FLOOR: {
                        ((Heightmap)entry.getValue()).m_64249_(j, i, l, pState);
                    }
                }
            });
            boolean flag1 = levelchunksection.m_188008_();
            if (flag != flag1) {
                level.m_6018_().m_7726_().m_7827_().m_75834_(pPos, flag1);
            }
            boolean flag2 = blockstate.m_155947_();
            if (!level.m_6018_().f_46443_) {
                blockstate.m_60753_((Level)level.m_6018_(), pPos, pState, false);
            } else if (!(blockstate.m_60713_(block) && pState.m_155947_() || !flag2)) {
                level.m_6018_().m_46747_(pPos);
            }
            if (levelchunksection.m_62982_(j, k, l).m_60713_(block)) {
                if (!level.m_6018_().f_46443_ && !level.m_6018_().captureBlockSnapshots) {
                    pState.m_60696_((Level)level.m_6018_(), pPos, blockstate, false);
                }
                access.m_8092_(true);
            }
        }
    }

    @Nullable
    public static BlockState setBlockState(BlockPos pPos, BlockState pState, boolean pIsMoving, ChunkAccess chunkAccess, WorldGenLevel worldGenLevel) {
        int l;
        int k;
        int i = pPos.m_123342_();
        LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151564_(i));
        boolean flag = levelchunksection.m_188008_();
        if (flag && pState.m_60795_()) {
            return null;
        }
        int j = pPos.m_123341_() & 0xF;
        BlockState blockstate = levelchunksection.m_62986_(j, k = i & 0xF, l = pPos.m_123343_() & 0xF, pState);
        if (blockstate == pState) {
            return null;
        }
        Block block = pState.m_60734_();
        boolean flag2 = blockstate.m_155947_();
        if (!worldGenLevel.m_5776_() && worldGenLevel instanceof Level) {
            blockstate.m_60753_((Level)worldGenLevel, pPos, pState, pIsMoving);
        } else if (!(blockstate.m_60713_(block) && pState.m_155947_() || !flag2)) {
            chunkAccess.m_8114_(pPos);
        }
        if (!levelchunksection.m_62982_(j, k, l).m_60713_(block)) {
            return null;
        }
        if (!worldGenLevel.m_5776_()) {
            pState.m_60696_((Level)worldGenLevel.m_6018_(), pPos, blockstate, pIsMoving);
        }
        chunkAccess.m_8092_(true);
        return blockstate;
    }

    private static boolean canGenerateSphere(WorldGenLevel world, BlockPos pos, ChunkAccess chunk) {
        BlockState state = chunk.m_8055_(pos);
        FluidState fluidState = chunk.m_6425_(pos);
        if (state.m_60795_() || state.m_60767_().m_76332_()) {
            return false;
        }
        if (!fluidState.m_76178_()) {
            return false;
        }
        if (pos.m_123342_() >= world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - 4) {
            return state.m_204336_(Tags.Blocks.STONE);
        }
        return state.m_204336_(Tags.Blocks.STONE);
    }

    private static boolean canSpawn(BlockState underState, BlockState state, BlockState upState) {
        boolean can;
        Block block = underState.m_60734_();
        boolean bl = can = block == Blocks.f_50440_ || block == Blocks.f_49994_ || block == Blocks.f_50493_ || block == Blocks.f_49992_ || block == Blocks.f_50652_ || block == Blocks.f_50069_;
        if (can) {
            if (AlgorithmVein.isCoralOrCoralBlock(state) || AlgorithmVein.isWaterPlant(state)) {
                return false;
            }
            if ((state.m_60795_() || state.m_60722_(Fluids.f_76191_)) && !(state.m_60734_() instanceof IPlantable)) {
                return true;
            }
            return state.m_60767_().m_76332_() && upState.m_60767_().m_76332_();
        }
        return false;
    }

    private static boolean canGenerate(WorldGenLevel world, BlockPos pos, ChunkAccess chunk) {
        BlockState state = chunk.m_8055_(pos);
        FluidState fluidState = chunk.m_6425_(pos);
        if (state.m_60795_() || state.m_60767_().m_76332_()) {
            return false;
        }
        if (!fluidState.m_76178_()) {
            return false;
        }
        if (pos.m_123342_() >= world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - 4) {
            return state.m_204336_(Tags.Blocks.STONE);
        }
        return state.m_204336_(Tags.Blocks.STONE);
    }

    private static boolean isCoralOrCoralBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13064_) || state.m_204336_(BlockTags.f_13051_);
    }

    private static boolean isWaterPlant(BlockState state) {
        Block b = state.m_60734_();
        return b instanceof SeagrassBlock || b instanceof KelpBlock || b == Blocks.f_50037_ || b == Blocks.f_50038_ || b == Blocks.f_50575_ || b == Blocks.f_50576_ || b == Blocks.f_50567_;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> p_159749_) {
        if (shellClusterChuncks.isEmpty()) {
            shellClusterList = PerlinNoiseViewer.createClusters(p_159749_.m_225041_());
            shellClusterList = new ArrayList<ShellCluster>(shellClusterList);
            for (ShellCluster cluster : shellClusterList) {
                Map tupleMap;
                if (WorldBaseGen.veinTypes1.isEmpty()) {
                    WorldBaseGen.veinTypes1 = new ArrayList<VeinType>(WorldBaseGen.veinTypes);
                }
                int meta = WorldBaseGen.random.nextInt(WorldBaseGen.veinTypes1.size());
                VeinType veinType = WorldBaseGen.veinTypes1.remove(meta);
                for (Point point : cluster.blacks) {
                    tupleMap = shellClusterChuncks.computeIfAbsent(point.x - 256, k -> new HashMap());
                    tupleMap.put(point.y - 256, new Tuple((Object)Color.BLACK, (Object)veinType.getId()));
                }
                for (Point point : cluster.grays) {
                    tupleMap = shellClusterChuncks.computeIfAbsent(point.x - 256, k -> new HashMap());
                    tupleMap.put(point.y - 256, new Tuple((Object)Color.GRAY, (Object)veinType.getId()));
                }
                for (Point point : cluster.lightGrays) {
                    tupleMap = shellClusterChuncks.computeIfAbsent(point.x - 256, k -> new HashMap());
                    tupleMap.put(point.y - 256, new Tuple((Object)Color.LIGHT_GRAY, (Object)veinType.getId()));
                }
            }
            volcano = PerlinNoiseViewer.createVolcanoClusters(p_159749_.m_225041_());
        }
        BlockPos origin = p_159749_.m_159777_();
        ChunkPos chunkPos = new ChunkPos(origin);
        Map<Integer, Tuple<Color, Integer>> tupleMap = shellClusterChuncks.get(chunkPos.f_45578_ % 256);
        if (tupleMap == null) {
            return false;
        }
        Tuple<Color, Integer> tuple = tupleMap.get(chunkPos.f_45579_ % 256);
        if (tuple != null) {
            ChunkAccess chunk = p_159749_.m_159774_().m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62314_, false);
            VeinType veinType = VeinType.veinTypeMap.get(tuple.m_14419_());
            Color color = (Color)tuple.m_14418_();
            VeinStructure veinStructure = new VeinStructure(p_159749_.m_159774_(), veinType, new BlockPos(chunkPos.f_45578_ * 16 + random.nextInt(16), 2, chunkPos.f_45579_ * 16 + random.nextInt(16)), chunk, veinType.getDeposits_meta());
            return AlgorithmVein.generate(p_159749_.m_159774_(), veinStructure.getVeinType(), veinStructure.getBlockPos(), veinStructure.getChunk(), veinStructure.getDepositsMeta(), color);
        }
        return false;
    }

    static {
        shellClusterChuncks = new HashMap<Integer, Map<Integer, Tuple<Color, Integer>>>();
    }
}

