/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api;

import com.denfop.recipe.IInputHandler;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class InputHandler
implements IInputHandler {
    @Override
    public IInputItemStack getInput(ItemStack stack) {
        return new InputItemStack(stack);
    }

    @Override
    public IInputItemStack getInput(ItemStack[] stacks) {
        if (stacks.length == 1) {
            return new InputItemStack(stacks[0]);
        }
        TagKey tag = (TagKey)stacks[0].getTags().toList().get(0);
        return new InputOreDict((TagKey<Item>)tag, stacks[0].getCount());
    }

    @Override
    public IInputItemStack getInput(Object var1) {
        if (var1 instanceof IInputItemStack) {
            return (IInputItemStack)var1;
        }
        if (var1 instanceof ItemStack) {
            return this.getInput((ItemStack)var1);
        }
        if (var1 instanceof Fluid) {
            return this.getInput((Fluid)var1);
        }
        if (var1 instanceof String) {
            return this.getInput((String)var1);
        }
        if (var1 instanceof Item) {
            return this.getInput(new ItemStack((ItemLike)((Item)var1)));
        }
        if (var1 instanceof TagKey) {
            return this.getInput((TagKey<Item>)((TagKey)var1));
        }
        if (var1 instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)var1;
            if (!ingredient.isCustom() && ingredient.getValues()[0] instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)ingredient.getValues()[0];
                return this.getInput((TagKey<Item>)tagValue.tag());
            }
            return this.getInput(ingredient.getItems());
        }
        if (var1 instanceof List) {
            List list = (List)var1;
            boolean allItemStacks = list.stream().allMatch(e -> e instanceof ItemStack);
            if (allItemStacks) {
                List itemStacks = list;
                return this.getInput(itemStacks.toArray(new ItemStack[0]));
            }
            List var2 = (List)var1;
            TagKey mainTag = (TagKey)var2.get(0);
            for (TagKey tagKey : var2) {
                StringBuilder location = new StringBuilder(tagKey.location().toString());
                if (location.indexOf("/") == -1) continue;
                mainTag = tagKey;
                break;
            }
            return this.getInput(mainTag.location());
        }
        return null;
    }

    @Override
    public IInputItemStack getInput(Object var1, int i) {
        if (var1 instanceof ItemStack) {
            return this.getInput((ItemStack)var1, i);
        }
        if (var1 instanceof Fluid) {
            return this.getInput((Fluid)var1, i);
        }
        if (var1 instanceof String) {
            return this.getInput((String)var1, i);
        }
        if (var1 instanceof TagKey) {
            return this.getInput((TagKey<Item>)((TagKey)var1), i);
        }
        return null;
    }

    public IInputItemStack getInput(TagKey<Item> name, int i) {
        return new InputOreDict(name, i);
    }

    public IInputItemStack getInput(TagKey<Item> name) {
        return new InputOreDict(name, 1);
    }

    @Override
    public IInputItemStack getInput(ItemStack stack, int amount) {
        return new InputItemStack(stack, amount);
    }

    @Override
    public IInputItemStack getInput(String name) {
        return new InputOreDict(name);
    }

    @Override
    public IInputItemStack getInput(String name, int amount) {
        return new InputOreDict(name, amount);
    }

    @Override
    public IInputItemStack getInput(String name, int amount, int metaOverride) {
        return new InputOreDict(name, amount, metaOverride);
    }

    @Override
    public IInputItemStack getInput(Fluid fluid) {
        return new InputFluidStack(fluid);
    }

    @Override
    public IInputItemStack getInput(Fluid fluid, int amount) {
        return new InputFluidStack(fluid, amount);
    }
}

