/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.gui.MouseButton;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiCore;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;

public abstract class GuiElement<T extends GuiElement<T>> {
    public static final ResourceLocation commonTexture = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/common.png");
    public static final ResourceLocation commonTexture1 = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_progressbars.png");
    public static final ResourceLocation commonTexture2 = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_progressbars1.png");
    public static final ResourceLocation commonTexture3 = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/steam_progressbars.png");
    public static final ResourceLocation commonTexture4 = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/bio_progressbars.png");
    public static final ResourceLocation commonTexture5 = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guispace_progress.png");
    protected GuiCore<?> gui;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private Supplier<String> tooltipProvider;

    protected GuiElement(GuiCore<?> gui, int x, int y, int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("negative width");
        }
        if (height < 0) {
            throw new IllegalArgumentException("negative height");
        }
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public static void addLines(List<String> list, String str) {
        int pos;
        int startPos = 0;
        while ((pos = str.indexOf(10, startPos)) != -1) {
            list.add(GuiElement.processText(str.substring(startPos, pos)));
            startPos = pos + 1;
        }
        if (startPos == 0) {
            list.add(GuiElement.processText(str));
        } else {
            list.add(GuiElement.processText(str.substring(startPos)));
        }
    }

    protected static String processText(String text) {
        return Localization.translate(text);
    }

    protected static void bindTexture(ResourceLocation texture) {
        GuiCore.bindTexture(texture);
    }

    public static void bindCommonTexture() {
        GuiCore.bindTexture(commonTexture);
    }

    public static void bindCommonTexture1() {
        GuiCore.bindTexture(commonTexture1);
    }

    public static void bindCommonTexture2() {
        GuiCore.bindTexture(commonTexture2);
    }

    public static void bindCommonTexture3() {
        GuiCore.bindTexture(commonTexture3);
    }

    public static void bindCommonTexture4() {
        GuiCore.bindTexture(commonTexture4);
    }

    public static void bindCommonTexture5() {
        GuiCore.bindTexture(commonTexture5);
    }

    public static void bindBlockTexture() {
        GuiCore.bindTexture(TextureAtlas.LOCATION_BLOCKS);
    }

    public static TextureAtlas getBlockTextureMap() {
        return (TextureAtlas)Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
    }

    public boolean visible() {
        return true;
    }

    public GuiCore<?> getGui() {
        return this.gui;
    }

    public void setGui(GuiCore<?> gui) {
        this.gui = gui;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public T withTooltip(String tooltip) {
        return this.withTooltip((Supplier<String>)Suppliers.ofInstance((Object)tooltip));
    }

    public T withTooltip(Supplier<String> tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
        return (T)this;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Supplier<String> getTooltipProvider() {
        return this.tooltipProvider;
    }

    public void tick() {
    }

    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
    }

    public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
        if (this.contains(mouseX, mouseY) && !this.suppressTooltip(mouseX, mouseY)) {
            String tooltip;
            List<String> lines = this.getToolTip();
            if (this.tooltipProvider != null && (tooltip = (String)this.tooltipProvider.get()) != null && !tooltip.isEmpty()) {
                GuiElement.addLines(lines, tooltip);
            }
            if (!lines.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, lines);
            }
        }
    }

    public boolean onMouseClick(int mouseX, int mouseY, MouseButton button, boolean onThis) {
        return onThis && this.onMouseClick(mouseX, mouseY, button);
    }

    protected boolean onMouseClick(int mouseX, int mouseY, MouseButton button) {
        return false;
    }

    public boolean onMouseDrag(int mouseX, int mouseY, MouseButton button, long timeFromLastClick, boolean onThis) {
        return onThis && this.onMouseDrag(mouseX, mouseY, button, timeFromLastClick);
    }

    public boolean onMouseDrag(int mouseX, int mouseY, MouseButton button, long timeFromLastClick) {
        return false;
    }

    public boolean onMouseRelease(int mouseX, int mouseY, MouseButton button, boolean onThis) {
        return onThis && this.onMouseRelease(mouseX, mouseY, button);
    }

    protected boolean onMouseRelease(int mouseX, int mouseY, MouseButton button) {
        return false;
    }

    public void onMouseScroll(int mouseX, int mouseY, ScrollDirection direction) {
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        return false;
    }

    protected boolean suppressTooltip(int mouseX, int mouseY) {
        return false;
    }

    protected List<String> getToolTip() {
        return new ArrayList<String>();
    }

    protected final Container getBase() {
        return ((ContainerBase)((Object)this.gui.getContainer())).base;
    }

    public void addY(int height) {
        this.y += height;
    }
}

