/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorModule;
import com.denfop.invslot.InvSlot;
import net.minecraft.world.item.ItemStack;

public class InvSlotReactorModules<T extends IAdvReactor & IAdvInventory>
extends InvSlot {
    private double stableHeat;
    private double radiation;
    private double generation;
    private double componentVent;
    private double vent;
    private double exchanger;
    private double capacitor;

    public InvSlotReactorModules(T base) {
        super((IAdvInventory)base, InvSlot.TypeItemSlot.INPUT, 4);
        this.setStackSizeLimit(1);
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        return stack.getItem() instanceof IReactorModule;
    }

    @Override
    public ItemStack set(int i, ItemStack content) {
        super.set(i, content);
        this.stableHeat = 1.0;
        this.radiation = 1.0;
        this.generation = 1.0;
        this.vent = 1.0;
        this.componentVent = 1.0;
        this.exchanger = 1.0;
        this.capacitor = 1.0;
        for (ItemStack stack : this.contents) {
            if (stack.isEmpty() || !(stack.getItem() instanceof IReactorModule)) continue;
            IReactorModule module = (IReactorModule)stack.getItem();
            this.stableHeat *= module.getStableHeat(stack);
            this.radiation *= module.getRadiation(stack);
            this.generation *= module.getGeneration(stack);
            this.componentVent *= module.getComponentVent(stack);
            this.vent *= module.getVent(stack);
            this.exchanger *= module.getExchanger(stack);
            this.capacitor *= module.getCapacitor(stack);
        }
        ((IAdvReactor)((Object)this.base)).setUpdate();
        return content;
    }

    public void load() {
        this.stableHeat = 1.0;
        this.radiation = 1.0;
        this.generation = 1.0;
        this.vent = 1.0;
        this.componentVent = 1.0;
        this.exchanger = 1.0;
        this.capacitor = 1.0;
        for (ItemStack stack : this.contents) {
            if (stack.isEmpty() || !(stack.getItem() instanceof IReactorModule)) continue;
            IReactorModule module = (IReactorModule)stack.getItem();
            this.stableHeat *= module.getStableHeat(stack);
            this.radiation *= module.getRadiation(stack);
            this.generation *= module.getGeneration(stack);
            this.componentVent *= module.getComponentVent(stack);
            this.vent *= module.getVent(stack);
            this.exchanger *= module.getExchanger(stack);
            this.capacitor *= module.getCapacitor(stack);
        }
        ((IAdvReactor)((Object)this.base)).setUpdate();
    }

    public double getStableHeat() {
        return this.stableHeat;
    }

    public double getRadiation() {
        return this.radiation;
    }

    public double getComponentVent() {
        return this.componentVent;
    }

    public double getGeneration() {
        return this.generation;
    }

    public double getExchanger() {
        return this.exchanger;
    }

    public double getCapacitor() {
        return this.capacitor;
    }

    public double getVent() {
        return this.vent;
    }
}

