/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.IFluidReactor;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.blocks.FluidName;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class LogicFluidReactor
extends LogicReactor {
    private final IFluidReactor reactorFluid;
    public double temp_heat = 0.0;

    public LogicFluidReactor(IFluidReactor advReactor) {
        super(advReactor);
        this.reactorFluid = advReactor;
    }

    @Override
    public void onTick() {
        if (!this.rodsList.isEmpty() && this.reactorFluid.getInputTank().getFluidAmount() > 0) {
            super.onTick();
            if (!this.reactorFluid.isFull()) {
                return;
            }
            if (this.temp_heat < this.getMaxHeat()) {
                this.temp_heat += (double)rand.nextInt(Math.max((int)(this.getMaxHeat() - this.temp_heat), 4) / 4);
                if (this.temp_heat > this.getMaxHeat()) {
                    this.temp_heat = this.getMaxHeat();
                }
            }
            if (this.reactorFluid.getInputTank().getFluidAmount() >= 5 * this.reactorFluid.getPressure()) {
                this.reactorFluid.getInputTank().drain(5 * this.reactorFluid.getPressure(), IFluidHandler.FluidAction.EXECUTE);
                if (this.reactorFluid.getOutputTank().getFluidAmount() + 2 * this.reactorFluid.getPressure() <= this.reactorFluid.getOutputTank().getCapacity()) {
                    this.reactorFluid.getOutputTank().fill(new FluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), 2 * this.reactorFluid.getPressure()), IFluidHandler.FluidAction.EXECUTE);
                    if (this.temp_heat > this.getMaxHeat()) {
                        this.temp_heat -= (double)rand.nextInt((int)Math.max(this.temp_heat - this.getMaxHeat(), 1.0));
                        if (this.temp_heat < 0.0) {
                            this.temp_heat = 0.0;
                        }
                    } else if (this.temp_heat > (double)this.reactorFluid.getStableMaxHeat() && this.temp_heat > this.getMaxHeat()) {
                        this.temp_heat -= (double)rand.nextInt((int)Math.max((this.temp_heat - (double)this.reactorFluid.getStableMaxHeat()) * 0.25, 1.0));
                        if (this.temp_heat < 0.0) {
                            this.temp_heat = 0.0;
                        }
                    }
                    this.reactorFluid.setOutput((double)this.generation * (1.0 + 0.02 * (double)(this.reactorFluid.getPressure() - 1)));
                } else {
                    this.temp_heat += (double)rand.nextInt(100);
                }
            } else {
                this.temp_heat += (double)rand.nextInt(150);
            }
            if (this.reactorFluid.getCoolantTank().getFluidAmount() >= 5 && this.reactorFluid.getHotCoolantTank().getFluidAmount() + 2 <= this.reactorFluid.getHotCoolantTank().getCapacity()) {
                this.reactorFluid.getCoolantTank().drain(5, IFluidHandler.FluidAction.EXECUTE);
                this.reactorFluid.getHotCoolantTank().fill(new FluidStack((Fluid)FluidName.fluidhot_coolant.getInstance().get(), 2), IFluidHandler.FluidAction.EXECUTE);
                if ((int)(this.temp_heat * 0.2) > 0) {
                    this.temp_heat -= (double)rand.nextInt((int)(this.temp_heat * 0.2));
                    if (this.temp_heat < 0.0) {
                        this.temp_heat = 0.0;
                    }
                }
                if (this.temp_heat < 0.0) {
                    this.temp_heat = 0.0;
                }
            }
        } else {
            if (this.getTemp_heat() > 0.0 && this.rodsList.isEmpty()) {
                this.temp_heat -= (double)rand.nextInt((int)(this.getTemp_heat() + 1.0));
                if (this.temp_heat < 0.0) {
                    this.temp_heat = 0.0;
                }
                this.reactor.setOutput(0.0);
            } else if (!this.rodsList.isEmpty()) {
                this.temp_heat += (double)rand.nextInt(200);
                this.reactor.setOutput(0.0);
            }
            this.reactor.setOutput(0.0);
        }
        this.reactorFluid.setHeat(this.temp_heat);
    }

    public double getTemp_heat() {
        return this.temp_heat;
    }

    public void setTemp_heat(double temp_heat) {
        this.temp_heat = temp_heat;
    }
}

