/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class RecipeInputStack
implements IRecipeInputStack {
    private final IInputItemStack input;

    public RecipeInputStack(IInputItemStack input) {
        this.input = input;
    }

    public RecipeInputStack(ItemStack input) {
        this.input = Recipes.inputFactory.getInput(Collections.singletonList(input));
    }

    @Override
    public List<ItemStack> getItemStack() {
        return this.input.getInputs();
    }

    @Override
    public boolean matched(ItemStack stack) {
        for (ItemStack input : this.getItemStack()) {
            if (input.getItem() != stack.getItem()) continue;
            if (stack.getComponents().isEmpty() || input.getComponents().isEmpty()) {
                return true;
            }
            return ModUtils.checkItemEquality(input, stack);
        }
        return false;
    }

    @Override
    public IInputItemStack getInput() {
        return this.input;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeInputStack that = (RecipeInputStack)o;
        for (ItemStack input : this.getItemStack()) {
            for (ItemStack input1 : that.getItemStack()) {
                if (input.getItem() != input1.getItem()) continue;
                if (input.getComponents().isEmpty()) {
                    return true;
                }
                return input.getComponents().equals((Object)input1.getComponents());
            }
        }
        return false;
    }
}

