/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.research.event.ResearchTableLoadEvent;
import com.denfop.api.space.research.event.ResearchTableUnLoadEvent;
import com.denfop.api.space.research.event.RocketPadLoadEvent;
import com.denfop.api.space.research.event.RocketPadUnLoadEvent;
import com.denfop.events.WorldSavedDataIU;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class EventHandlerPlanet {
    public static WorldSavedDataIU data;
    private final boolean load;
    int tick = 0;

    public EventHandlerPlanet() {
        this.load = false;
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ++this.tick;
        if (this.tick % 20 == 0) {
            SpaceNet.instance.getFakeSpaceSystem().working();
            SpaceNet.instance.getColonieNet().working();
        }
    }

    @SubscribeEvent
    public void load(ResearchTableLoadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Map<UUID, IResearchTable> map = SpaceNet.instance.getFakeSpaceSystem().getResearchTableMap();
        if (!map.containsKey(event.table.getPlayer())) {
            map.put(event.table.getPlayer(), event.table);
        }
    }

    @SubscribeEvent
    public void unLoad(ResearchTableUnLoadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Map<UUID, IResearchTable> map = SpaceNet.instance.getFakeSpaceSystem().getResearchTableMap();
        map.remove(event.table.getPlayer());
    }

    @SubscribeEvent
    public void loadRocketPad(RocketPadLoadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Map<UUID, IRocketLaunchPad> map = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap();
        if (!map.containsKey(event.table.getPlayer())) {
            map.put(event.table.getPlayer(), event.table);
        }
    }

    @SubscribeEvent
    public void unLoadRocketPad(RocketPadUnLoadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Map<UUID, IRocketLaunchPad> map = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap();
        map.remove(event.table.getPlayer());
    }

    @SubscribeEvent
    public void onSave(LevelEvent.Save event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD && data != null) {
            data.setDirty(true);
        }
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD && data != null) {
            data.setDirty(true);
        }
    }
}

