/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.sytem;

import com.denfop.api.energy.NodeStats;
import com.denfop.api.energy.SystemTick;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IConductor;
import com.denfop.api.sytem.IDual;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.sytem.ILocalNet;
import com.denfop.api.sytem.ISink;
import com.denfop.api.sytem.ISource;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoCable;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.sytem.Path;
import com.denfop.api.sytem.SystemTickList;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;

public class LocalNet
implements ILocalNet {
    final SystemTickList<SystemTick<ISource, Path>> senderPath = new SystemTickList();
    private final Map<BlockPos, ITile> chunkCoordinatesTileMap;
    private final EnergyType energyType;
    List<ISource> sourceToUpdateList = new ArrayList<ISource>();
    private int tick;

    public LocalNet(EnergyType energyType) {
        this.energyType = energyType;
        this.chunkCoordinatesTileMap = new HashMap<BlockPos, ITile>();
        this.tick = 0;
    }

    public void put(ISource par1, List<Path> par2) {
        this.senderPath.add(new SystemTick<ISource, Path>(par1, par2));
    }

    public boolean containsKey(SystemTick<ISource, Path> par1) {
        return this.senderPath.contains(par1);
    }

    public boolean containsKey(ISource par1) {
        return this.senderPath.contains(new SystemTick(par1, null));
    }

    public void remove1(ISource par1) {
        for (SystemTick systemTick : this.senderPath) {
            if (systemTick.getSource() != par1) continue;
            if (systemTick.getList() != null) {
                for (Path path : systemTick.getList()) {
                    path.target.getEnergyTickList().remove(systemTick.getSource());
                }
            }
            systemTick.setList(null);
            break;
        }
    }

    public void remove(ISource par1) {
        SystemTick<ISource, Path> energyTick = this.senderPath.removeSource(par1);
        if (energyTick != null && energyTick.getList() != null) {
            for (Path path : energyTick.getList()) {
                path.target.getEnergyTickList().remove(energyTick.getSource());
            }
        }
    }

    public void removeAll(List<SystemTick<ISource, Path>> par1) {
        if (par1 == null) {
            return;
        }
        for (SystemTick<ISource, Path> IEnergySource2 : par1) {
            if (IEnergySource2.getList() != null) {
                for (Path path : IEnergySource2.getList()) {
                    path.target.getEnergyTickList().remove(IEnergySource2.getSource());
                }
            }
            IEnergySource2.setList(null);
        }
    }

    @Override
    public List<Path> getPaths(IAcceptor par1) {
        ArrayList<Path> paths = new ArrayList<Path>();
        List<SystemTick<ISource, Path>> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (SystemTick<ISource, Path> source : sources_list) {
            paths.addAll(source.getList());
        }
        return paths;
    }

    public List<SystemTick<ISource, Path>> getSources(IAcceptor par1) {
        if (par1 instanceof ISink) {
            LinkedList<SystemTick<ISource, Path>> list = new LinkedList<SystemTick<ISource, Path>>();
            for (SystemTick systemTick : this.senderPath) {
                if (!((ISink)par1).getEnergyTickList().contains(systemTick.getSource())) continue;
                list.add(systemTick);
            }
            return list;
        }
        if (par1 instanceof IConductor) {
            LinkedList<SystemTick> list = new LinkedList<SystemTick>();
            for (SystemTick systemTick : this.senderPath) {
                if (!systemTick.getConductors().contains(par1)) continue;
                list.add(systemTick);
            }
            return new ArrayList<SystemTick<ISource, Path>>(list);
        }
        return Collections.emptyList();
    }

    public void clear() {
        this.senderPath.clear();
    }

    public SystemTick<ISource, Path> get(ISource tileEntity) {
        for (SystemTick systemTick : this.senderPath) {
            if (systemTick.getSource() != tileEntity) continue;
            return systemTick;
        }
        return null;
    }

    public double emitEnergyFrom(ISource energySource, double amount, SystemTick<ISource, Path> tick) {
        List energyPaths = tick.getList();
        if (energyPaths == null) {
            Tuple<List<Path>, LinkedList<IConductor>> tuples = this.discover(energySource, tick);
            energyPaths = (List)tuples.getA();
            LinkedList<IConductor> conductors = tick.getConductors();
            if (conductors == null) {
                tick.setConductors((LinkedList)tuples.getB());
            } else {
                tick.setConductors((LinkedList)tuples.getB());
            }
            tick.setList(energyPaths);
        }
        if (!(energySource instanceof IDual) && energySource.isSource()) {
            energySource.setPastEnergy(energySource.getPerEnergy());
        } else if (energySource instanceof IDual && energySource.isSource()) {
            ((IDual)energySource).setPastEnergy1(((IDual)energySource).getPerEnergy1());
        }
        if (amount > 0.0) {
            for (Path energyPath : energyPaths) {
                if (amount <= 0.0) break;
                ISink energySink = energyPath.target;
                double demandedEnergy = energySink.getDemanded();
                if (demandedEnergy <= 0.0) continue;
                double energyProvided = Math.min(demandedEnergy, amount);
                energySink.receivedEnergy(energyProvided);
                if (!(energySource instanceof IDual) && energySource.isSource()) {
                    energySource.addPerEnergy(energyProvided);
                } else if (energySource instanceof IDual && energySource.isSource()) {
                    ((IDual)energySource).addPerEnergy1(energyProvided);
                }
                energyPath.tick(this.tick, energyProvided);
                if (!this.energyType.isDraw()) continue;
                amount -= energyProvided;
                amount = Math.max(0.0, amount);
            }
        }
        return amount;
    }

    @Override
    public void TickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (ISource iSource : this.sourceToUpdateList) {
                this.remove1(iSource);
            }
            this.sourceToUpdateList.clear();
        }
        for (SystemTick systemTick : this.senderPath) {
            double offer;
            ISource entry = (ISource)systemTick.getSource();
            if (systemTick.getList() != null && systemTick.getList().isEmpty() || entry == null) continue;
            if (entry.isSource()) {
                if (entry instanceof IDual) {
                    ((IDual)entry).setPastEnergy1(((IDual)entry).getPastEnergy1());
                } else {
                    entry.setPastEnergy(entry.getPerEnergy());
                }
            }
            if ((offer = entry.canProvideEnergy()) > 0.0) {
                double removed = offer - this.emitEnergyFrom(entry, offer, systemTick);
                if (!this.energyType.isDraw()) continue;
                entry.extractEnergy(removed);
                continue;
            }
            if (!entry.isSource()) continue;
            if (entry instanceof IDual) {
                ((IDual)entry).setPastEnergy1(((IDual)entry).getPastEnergy1());
                continue;
            }
            entry.setPastEnergy(entry.getPerEnergy());
        }
        ++this.tick;
    }

    public double getTotalEmitted(ITile tileEntity) {
        double ret = 0.0;
        boolean col = false;
        if (tileEntity instanceof ISource) {
            ISource advEnergySource = (ISource)tileEntity;
            if (!(advEnergySource instanceof IDual) && advEnergySource.isSource()) {
                ret = Math.max(0.0, advEnergySource.getPerEnergy() - advEnergySource.getPastEnergy());
            } else if (advEnergySource instanceof IDual && advEnergySource.isSource()) {
                IDual dual = (IDual)advEnergySource;
                ret = Math.max(0.0, dual.getPerEnergy1() - dual.getPastEnergy1());
            }
        }
        return !col ? ret : ret / (double)col;
    }

    public double getTotalAccepted(ITile tileEntity) {
        ISink advEnergySink;
        double ret = 0.0;
        if (tileEntity instanceof ISink && (advEnergySink = (ISink)tileEntity).isSink() && ((double)(this.tick - 1) == advEnergySink.getTick() || (double)this.tick == advEnergySink.getTick() || (double)(this.tick + 1) == advEnergySink.getTick())) {
            ret = Math.max(0.0, advEnergySink.getPerEnergy() - advEnergySink.getPastEnergy());
        }
        return ret;
    }

    @Override
    public NodeStats getNodeStats(ITile tile) {
        double emitted = this.getTotalEmitted(tile);
        double received = this.getTotalAccepted(tile);
        return new NodeStats(received, emitted);
    }

    @Override
    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesTileMap.clear();
    }

    @Override
    public ITile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesTileMap.get(pos);
    }

    @Override
    public void addTile(ITile tile1) {
        this.addTileEntity(tile1.getPos(), tile1);
    }

    @Override
    public void removeTile(ITile tile1) {
        this.removeTileEntity(tile1);
    }

    private void updateRemove(BlockPos pos, ITile tile) {
        for (Direction dir : Direction.values()) {
            BlockPos pos1 = pos.offset(dir.getNormal());
            ITile tile1 = this.chunkCoordinatesTileMap.get(pos1);
            if (tile1 == null) continue;
            tile1.RemoveTile(this.energyType, tile, dir.getOpposite());
        }
    }

    public void removeTileEntity(ITile tile) {
        if (!this.chunkCoordinatesTileMap.containsKey(tile.getPos())) {
            return;
        }
        BlockPos coord = tile.getPos();
        this.chunkCoordinatesTileMap.remove(coord);
        if (tile instanceof IAcceptor) {
            this.removeAll(this.getSources((IAcceptor)tile));
        }
        if (tile instanceof ISource) {
            this.remove((ISource)tile);
        }
        this.updateRemove(coord, tile);
    }

    public Tuple<List<Path>, LinkedList<IConductor>> discover(ISource emitter, SystemTick<ISource, Path> tick) {
        LinkedList<ITile> tileEntitiesToCheck = new LinkedList<ITile>();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList<IConductor> set = new LinkedList<IConductor>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ITile currentTileEntity = (ITile)tileEntitiesToCheck.pop();
            List<InfoTile<ITile>> validReceivers = this.getValidReceivers(currentTileEntity);
            InfoCable cable = null;
            if (currentTileEntity instanceof IConductor) {
                cable = ((IConductor)currentTileEntity).getCable(this.energyType);
            }
            for (InfoTile<ITile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter || ((ITile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((ITile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof ISink) {
                    energyPaths.add(new Path((ISink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof IConductor)) continue;
                IConductor conductor = (IConductor)validReceiver.tileEntity;
                conductor.setCable(this.energyType, new InfoCable(conductor, validReceiver.direction, cable));
                tileEntitiesToCheck.push((ITile)validReceiver.tileEntity);
            }
        }
        int id1 = WorldBaseGen.random.nextInt();
        energyPaths = new ArrayList(energyPaths);
        block2: for (Path energyPath : energyPaths) {
            ITile tileEntity = energyPath.target;
            energyPath.target.getEnergyTickList().add(tick.getSource());
            Direction energyBlockLink = energyPath.targetDirection;
            tileEntity = tileEntity.getTiles(this.energyType).get(energyBlockLink);
            if (!(tileEntity instanceof IConductor)) continue;
            InfoCable cable = ((IConductor)tileEntity).getCable(this.energyType);
            while (cable != null) {
                IConductor energyConductor = cable.getConductor();
                if (energyConductor.getHashCodeSource() != id1) {
                    energyConductor.setHashCodeSource(id1);
                    set.add(energyConductor);
                }
                if ((cable = cable.getPrev()) != null) continue;
                continue block2;
            }
        }
        return new Tuple((Object)energyPaths, set);
    }

    public List<InfoTile<ITile>> getValidReceivers(ITile emitter) {
        BlockPos tile1 = emitter.getPos();
        if (tile1 != null) {
            if (emitter instanceof IDual) {
                LinkedList<InfoTile<ITile>> validReceivers = new LinkedList<InfoTile<ITile>>();
                for (InfoTile<ITile> entry : emitter.getValidReceivers(this.energyType)) {
                    ITile target2 = (ITile)entry.tileEntity;
                    if (target2 == emitter || target2 == null) continue;
                    Direction inverseDirection2 = entry.direction;
                    if (target2 instanceof IAcceptor) {
                        IEmitter sender2 = (IEmitter)emitter;
                        IAcceptor receiver2 = (IAcceptor)target2;
                        if (!sender2.emitsTo(receiver2, inverseDirection2.getOpposite()) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
                        validReceivers.add(entry);
                        continue;
                    }
                    validReceivers.add(entry);
                }
                return validReceivers;
            }
            LinkedList<InfoTile<ITile>> validReceivers = new LinkedList<InfoTile<ITile>>();
            for (InfoTile<ITile> entry : emitter.getValidReceivers(this.energyType)) {
                ITile target2 = (ITile)entry.tileEntity;
                if (target2 == emitter || target2 == null) continue;
                Direction inverseDirection2 = entry.direction;
                if (!(!(target2 instanceof IAcceptor) || target2 instanceof IConductor && emitter instanceof IConductor)) {
                    IEmitter sender2 = (IEmitter)emitter;
                    IAcceptor receiver2 = (IAcceptor)target2;
                    if (!sender2.emitsTo(receiver2, inverseDirection2.getOpposite()) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
                    validReceivers.add(entry);
                    continue;
                }
                validReceivers.add(entry);
            }
            return validReceivers;
        }
        return Collections.emptyList();
    }

    public void addTileEntity(BlockPos coords, ITile tile) {
        if (this.chunkCoordinatesTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof IAcceptor) {
            this.onTileEntityAdded((IAcceptor)tile);
        }
        if (tile instanceof ISource) {
            this.senderPath.add(new SystemTick((ISource)tile, null));
        }
    }

    private void updateAdd(BlockPos pos, ITile tile) {
        for (Direction dir : Direction.values()) {
            IAcceptor receiver2;
            IEmitter sender2;
            BlockPos pos1 = pos.offset(dir.getNormal());
            ITile tile1 = this.chunkCoordinatesTileMap.get(pos1);
            if (tile1 == null) continue;
            Direction inverseDirection2 = dir.getOpposite();
            if (tile instanceof IDual) {
                tile1.AddTile(this.energyType, tile, inverseDirection2);
                tile.AddTile(this.energyType, tile1, dir);
                continue;
            }
            if (tile1 instanceof IEmitter && tile instanceof IAcceptor) {
                sender2 = (IEmitter)tile1;
                receiver2 = (IAcceptor)tile;
                if (tile1 instanceof IDual) {
                    tile1.AddTile(this.energyType, tile, inverseDirection2);
                    tile.AddTile(this.energyType, tile1, dir);
                    continue;
                }
                if (!sender2.emitsTo(receiver2, dir.getOpposite()) || !receiver2.acceptsFrom(sender2, inverseDirection2.getOpposite())) continue;
                tile1.AddTile(this.energyType, tile, dir.getOpposite());
                tile.AddTile(this.energyType, tile1, dir);
                continue;
            }
            if (!(tile1 instanceof IAcceptor) || !(tile instanceof IEmitter)) continue;
            sender2 = (IEmitter)tile;
            receiver2 = (IAcceptor)tile1;
            if (tile1 instanceof IDual) {
                tile1.AddTile(this.energyType, tile, inverseDirection2);
                tile.AddTile(this.energyType, tile1, dir);
                continue;
            }
            if (!sender2.emitsTo(receiver2, dir) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
            tile1.AddTile(this.energyType, tile, dir.getOpposite());
            tile.AddTile(this.energyType, tile1, dir);
        }
    }

    public void onTileEntityAdded(IAcceptor tile) {
        LinkedList<ITile> tileEntitiesToCheck = new LinkedList<ITile>();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        this.sourceToUpdateList = new LinkedList<ISource>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ITile currentTileEntity = (ITile)tileEntitiesToCheck.pop();
            List<InfoTile<ITile>> validReceivers = currentTileEntity.getValidReceivers(this.energyType);
            for (InfoTile<ITile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((ITile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((ITile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof ISource) {
                    this.sourceToUpdateList.add((ISource)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof IConductor)) continue;
                tileEntitiesToCheck.push((ITile)validReceiver.tileEntity);
            }
        }
        this.sourceToUpdateList = new ArrayList<ISource>(this.sourceToUpdateList);
    }
}

