/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein;

import com.denfop.ModConfig;
import com.denfop.api.vein.IVeinSystem;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.Vein;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.Tags;

public class VeinSystem
implements IVeinSystem {
    public static IVeinSystem system;
    public static Vein EMPTY;
    private final Random rand;
    List<Vein> list;
    List<ChunkPos> chunkPos;
    Map<ChunkPos, Vein> chunkPosVeinMap;

    public VeinSystem() {
        system = this;
        this.list = new ArrayList<Vein>();
        this.chunkPos = new ArrayList<ChunkPos>();
        this.chunkPosVeinMap = new HashMap<ChunkPos, Vein>();
        this.rand = new Random();
    }

    @Override
    public Vein getEMPTY() {
        return EMPTY;
    }

    @Override
    public List<ChunkPos> getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public List<Vein> getVeinsList() {
        return this.list;
    }

    @Override
    public void addVein(LevelChunk chunk) {
        int col;
        Random rand = new Random();
        int chance = rand.nextInt(100);
        Vein vein = new Vein(Type.EMPTY, 0, chunk.getPos());
        Holder holder = chunk.getLevel().getBiome(new BlockPos(chunk.getPos().x * 16, 0, chunk.getPos().z * 16));
        int n = col = holder.is(BiomeTags.IS_HILL) ? 25 : 0;
        if (chance >= 15 + col) {
            int n2 = col = holder.is(BiomeTags.IS_TAIGA) || holder.is(Tags.Biomes.IS_SNOWY) ? 15 : 0;
            if (rand.nextInt(100) < 85 - col) {
                this.getnumber(vein, (Holder<Biome>)holder);
            } else {
                vein.setType(Type.GAS);
                vein.setOldMineral(false);
                vein.setMeta(0);
                vein.setMaxCol(450000);
                vein.setCol(450000);
            }
            this.getnumber(vein, (Holder<Biome>)holder);
        } else {
            int meta = rand.nextInt(16);
            vein.setType(Type.VEIN);
            vein.setOldMineral(meta <= 15);
            vein.setMeta(meta);
            vein.setMaxCol((Integer)ModConfig.COMMON.maxVein.get());
            vein.setCol((Integer)ModConfig.COMMON.maxVein.get());
        }
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public void addVein(CompoundTag tag) {
        Vein vein = new Vein(tag);
        if (!this.list.contains(vein)) {
            this.list.add(vein);
            this.chunkPos.add(vein.getChunk());
            this.chunkPosVeinMap.put(vein.getChunk(), vein);
        }
    }

    @Override
    public Vein getVein(ChunkPos pos) {
        return this.chunkPosVeinMap.getOrDefault(pos, EMPTY);
    }

    @Override
    public void unload() {
        this.list.clear();
        this.chunkPos.clear();
        this.chunkPosVeinMap.clear();
    }

    private void getnumber(Vein vein, Holder<Biome> biome) {
        this.rand.setSeed(this.rand.nextLong());
        int meta = this.rand.nextInt(6);
        if (biome.is(Tags.Biomes.IS_DESERT)) {
            int random = this.rand.nextInt(100);
            if (random >= 35) {
                int number = this.rand.nextInt(500000) + 150000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (biome.is(BiomeTags.IS_OCEAN)) {
            int random = this.rand.nextInt(100);
            if (random >= 40) {
                int number = this.rand.nextInt(500000) + 150000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (biome.is(BiomeTags.IS_DEEP_OCEAN)) {
            int random = this.rand.nextInt(100);
            if (random > 35) {
                int number = this.rand.nextInt(300000) + 100000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (biome.is(BiomeTags.IS_RIVER)) {
            int random = this.rand.nextInt(100);
            if (random > 50) {
                int number = this.rand.nextInt(200000) + 50000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (biome.is(BiomeTags.IS_SAVANNA)) {
            int random = this.rand.nextInt(100);
            if (random > 50) {
                int number = this.rand.nextInt(300000) + 100000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else {
            int random = this.rand.nextInt(100);
            if (random > 89) {
                int number = this.rand.nextInt(300000);
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        }
    }

    static {
        EMPTY = new Vein(Type.EMPTY, 0, new ChunkPos(999999999, 999999999));
    }
}

