/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.windsystem.upgrade;

import com.denfop.IUItem;
import com.denfop.api.windsystem.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.api.windsystem.upgrade.IRotorUpgradeItem;
import com.denfop.api.windsystem.upgrade.IRotorUpgradeSystem;
import com.denfop.api.windsystem.upgrade.RotorUpgradeItemInform;
import com.denfop.api.windsystem.upgrade.event.EventRotorItemLoad;
import com.denfop.datacomponent.DataComponentsInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

public class RotorUpgradeSystem
implements IRotorUpgradeSystem {
    public static IRotorUpgradeSystem instance;
    int max = 0;

    public RotorUpgradeSystem() {
        instance = this;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void loadItem(EventRotorItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @Override
    public int getRemaining(ItemStack item) {
        List list = (List)item.getOrDefault(DataComponentsInit.WIND_UPGRADE, Collections.emptyList());
        int col = 0;
        for (RotorUpgradeItemInform rotorUpgradeItemInform : list) {
            col += rotorUpgradeItemInform.number;
        }
        return 4 - col;
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        return stack.has(DataComponentsInit.WIND_UPGRADE);
    }

    @Override
    public List<RotorUpgradeItemInform> getInformation(ItemStack item) {
        return (List)item.getOrDefault(DataComponentsInit.WIND_UPGRADE, Collections.emptyList());
    }

    @Override
    public RotorUpgradeItemInform getModules(EnumInfoRotorUpgradeModules module, ItemStack item) {
        List<RotorUpgradeItemInform> list = this.getInformation(item);
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public RotorUpgradeItemInform getModules(EnumInfoRotorUpgradeModules module, List<RotorUpgradeItemInform> list) {
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumInfoRotorUpgradeModules module, ItemStack item) {
        if (!(item.getItem() instanceof IRotorUpgradeItem)) {
            return false;
        }
        List<RotorUpgradeItemInform> list = this.getInformation(item);
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModules(EnumInfoRotorUpgradeModules module, ItemStack item, List<RotorUpgradeItemInform> list) {
        if (!(item.getItem() instanceof IRotorUpgradeItem)) {
            return false;
        }
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IRotorUpgradeItem item, ItemStack stack) {
        if (!stack.has(DataComponentsInit.WIND_UPGRADE)) {
            stack.set(DataComponentsInit.WIND_UPGRADE, new ArrayList());
        }
        this.setInformation(item, Collections.emptyList(), stack);
    }

    @Override
    public void setInformation(IRotorUpgradeItem item, List<EnumInfoRotorUpgradeModules> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        this.max = 0;
    }

    @Override
    public void write(IRotorUpgradeItem item, List<EnumInfoRotorUpgradeModules> lst, ItemStack stack) {
    }

    @Override
    public void removeUpdate(ItemStack stack, Level world, int index) {
        stack.set(DataComponentsInit.WIND_UPGRADE, new ArrayList());
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        List listUpgrade = (List)stack.getOrDefault(DataComponentsInit.WIND_UPGRADE, Collections.emptyList());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (RotorUpgradeItemInform rotorUpgradeItemInform : listUpgrade) {
            for (int i = 0; i < rotorUpgradeItemInform.number; ++i) {
                list.add(new ItemStack((ItemLike)IUItem.rotors_upgrade.getStack(rotorUpgradeItemInform.upgrade.ordinal()), 1));
            }
        }
        if (list.size() < 4) {
            for (int i = list.size() - 1; i < list.size(); ++i) {
                list.add(ItemStack.EMPTY);
                if (list.size() >= 4) break;
            }
        }
        return list;
    }

    @Override
    public Map<Integer, ItemStack> getList(ItemStack stack) {
        List listUpgrade = (List)stack.getOrDefault(DataComponentsInit.WIND_UPGRADE, Collections.emptyList());
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        int j = 0;
        for (RotorUpgradeItemInform rotorUpgradeItemInform : listUpgrade) {
            for (int i = 0; i < rotorUpgradeItemInform.number; ++i) {
                map.put(j, new ItemStack((ItemLike)IUItem.rotors_upgrade.getStack(rotorUpgradeItemInform.upgrade.ordinal()), 1));
                ++j;
            }
        }
        if (++j < 4) {
            for (int i = j - 1; i < j; ++i) {
                map.put(j, ItemStack.EMPTY);
            }
        }
        return map;
    }

    @Override
    public void addUpdate(ItemStack itemStack, Level world, EnumInfoRotorUpgradeModules fromID) {
        List rotorUpgradeItemInforms = (List)itemStack.getOrDefault(DataComponentsInit.WIND_UPGRADE, new ArrayList());
        boolean find = false;
        for (RotorUpgradeItemInform rotorUpgradeItemInform : rotorUpgradeItemInforms) {
            if (rotorUpgradeItemInform.upgrade != fromID) continue;
            ++rotorUpgradeItemInform.number;
            find = true;
            break;
        }
        if (!find) {
            rotorUpgradeItemInforms.add(new RotorUpgradeItemInform(fromID, 1));
        }
        itemStack.set(DataComponentsInit.WIND_UPGRADE, (Object)rotorUpgradeItemInforms);
    }

    @Override
    public boolean shouldUpdate(EnumInfoRotorUpgradeModules type, ItemStack stack1) {
        List<RotorUpgradeItemInform> list = this.getInformation(stack1);
        for (RotorUpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.max) continue;
            return false;
        }
        return true;
    }
}

