/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.DataBlock;
import com.denfop.DataMultiBlock;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;

public abstract class BlockCore<T extends Enum<T>>
extends Block {
    final String modName;
    private final T[] elements;
    private final DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> data;
    private final DataMultiBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> multiData;
    private final T element;

    public BlockCore(MapColor material, T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.of().mapColor(material));
        this.elements = elements;
        this.data = dataBlock;
        this.element = element;
        this.multiData = null;
        this.modName = "industrialupgrade";
    }

    public BlockCore(BlockBehaviour.Properties properties, T[] elements, DataMultiBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(properties);
        this.elements = elements;
        this.multiData = dataBlock;
        this.data = null;
        this.element = elements[0];
        this.modName = "industrialupgrade";
    }

    public BlockCore(BlockBehaviour.Properties properties, T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(properties);
        this.elements = elements;
        this.data = dataBlock;
        this.element = element;
        this.modName = "industrialupgrade";
        this.multiData = null;
    }

    public DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> getData() {
        return this.data;
    }

    public T getElement() {
        return this.element;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (this.data != null) {
            return new ItemStack(this.data.getItem(this.getMetaFromState(state)));
        }
        if (this.multiData != null) {
            return new ItemStack(this.multiData.getItem(this.getMetaFromState(state)));
        }
        return ItemStack.EMPTY;
    }

    public DataMultiBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> getMultiData() {
        return this.multiData;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder p_60538_) {
        Object object;
        ItemStack tool = (ItemStack)p_60538_.getParameter(LootContextParams.TOOL);
        BlockPos pos = BlockPos.containing((Position)((Position)p_60538_.getParameter(LootContextParams.ORIGIN)));
        Object drops = NonNullList.create();
        if (tool.isEmpty() && (object = p_60538_.getOptionalParameter(LootContextParams.THIS_ENTITY)) instanceof Player) {
            Player player = (Player)object;
            tool = player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        drops = this.getDrops((Level)p_60538_.getLevel(), pos, state, EnchantmentHelper.getItemEnchantmentLevel((Holder)p_60538_.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)tool));
        return drops;
    }

    public List<ItemStack> getDrops(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, int fortune) {
        if (this.data != null) {
            return List.of(new ItemStack(this.getData().getItem(this.getMetaFromState(state))));
        }
        if (this.multiData != null) {
            return List.of(new ItemStack(this.getMultiData().getItem(this.getMetaFromState(state))));
        }
        return List.of(ItemStack.EMPTY);
    }

    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    public T[] getElements() {
        return this.elements;
    }

    abstract <T extends Enum<T>> BlockState getStateForPlacement(T var1, BlockPlaceContext var2);

    abstract <T extends Enum<T>> void fillItemCategory(CreativeModeTab var1, NonNullList<ItemStack> var2, T var3);
}

