/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.DataBlock;
import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import oshi.util.tuples.Pair;

public class BlockSpace1<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public BlockSpace1(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).destroyTime(1.0f).explosionResistance(5.0f).sound(SoundType.STONE).requiresCorrectToolForDrops(), elements, element, dataBlock);
        BlockTagsProvider.list.add(this);
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder p_60538_) {
        Type type;
        RandomSource rand = p_60538_.getLevel().random;
        NonNullList ret = NonNullList.create();
        ItemStack stack1 = (ItemStack)p_60538_.getOptionalParameter(LootContextParams.TOOL);
        int fortune = 0;
        if (stack1 != null) {
            fortune = EnchantmentHelper.getItemEnchantmentLevel((Holder)p_60538_.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)stack1);
        }
        if ((type = (Type)this.getElement()).ordinal() == 0 || type.ordinal() == 1 || type.ordinal() == 4 || type.ordinal() == 7 || type.ordinal() == 12 || type.ordinal() == 13 || type.ordinal() == 14) {
            ItemStack stack = type.getStack();
            if (stack == null) {
                stack = Recipes.inputFactory.getInput(type.getRaw()).getInputs().get(0);
                type.setStack(stack);
            }
            stack = stack.copy();
            stack.setCount(1 + this.getDrop(fortune));
            ret.add((Object)stack);
        } else if (type.ordinal() == 6) {
            int i = WorldBaseGen.random.nextInt(fortune + 1) + 1;
            ret.add((Object)new ItemStack((ItemLike)Items.DIAMOND, i));
        } else if (type.ordinal() == 10) {
            int i = WorldBaseGen.random.nextInt(fortune + 1) + 1;
            ret.add((Object)new ItemStack((ItemLike)Items.EMERALD, i));
        } else if (type.ordinal() == 11) {
            ret.add((Object)ModUtils.setSize(IUItem.smallSulfurDust, 4 + WorldBaseGen.random.nextInt(fortune + 1)));
        } else if (type.ordinal() == 9) {
            int i = WorldBaseGen.random.nextInt(fortune + 2) + 1;
            ret.add((Object)new ItemStack((ItemLike)Items.QUARTZ, i));
        } else if (type.ordinal() == 5) {
            if (WorldBaseGen.random.nextDouble() < 0.5) {
                ret.add((Object)new ItemStack((ItemLike)IUItem.apatite.getItem(1), 1));
            } else {
                ret.add((Object)new ItemStack((ItemLike)IUItem.apatite.getItem(0), 1));
            }
        } else {
            ret.add((Object)new ItemStack((ItemLike)this, 1));
        }
        return ret;
    }

    public int quantityDropped(int fortune, RandomSource random) {
        return this.quantityDroppedWithBonus(fortune, random);
    }

    public int quantityDroppedWithBonus(int fortune, @Nonnull RandomSource random) {
        return fortune == 0 ? 1 : 1 + random.nextInt(fortune);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
    }

    public int quantityRedstoneDroppedWithBonus(int fortune, Random random) {
        return this.quantityRedstoneDropped(random) + random.nextInt(fortune + 1);
    }

    public int quantityRedstoneDropped(Random random) {
        return 4 + random.nextInt(2);
    }

    private int getDrop(int fortune) {
        switch (fortune) {
            case 0: {
                return 0;
            }
            case 1: {
                return WorldBaseGen.random.nextInt(100) < 50 ? 1 : 0;
            }
            case 2: {
                return WorldBaseGen.random.nextInt(100) < 100 ? 1 : 1;
            }
        }
        return WorldBaseGen.random.nextInt(100) < 50 ? 2 : 1;
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)this.stateDefinition.any();
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.stateDefinition.any()).getBlock()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"pickaxe", (Object)1);
    }

    public static enum Type implements ISubEnum
    {
        europa_mikhail_ore(0),
        ganymede_aluminium_ore(1),
        ganymede_beryllium(2),
        ganymede_calcium(3),
        ganymede_tungsten_ore(4),
        haumea_apatite(5),
        haumea_diamond(6),
        haumea_iridium(7),
        haumea_lithium(8),
        haumea_quartz(9),
        io_emerald_ore(10),
        io_sulfur(11),
        makemake_bismuth(12),
        makemake_gold(13),
        makemake_silver(14),
        mars_adamantium_ore(15);

        private final int metadata;
        private final String name;
        ItemStack stack;
        private String raw;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
            this.setRaw(this.getName().split("_")[1]);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        public String getRaw() {
            return this.raw;
        }

        public void setRaw(String name) {
            this.raw = "c:raw_materials/" + name;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "blockspace2";
        }

        public int getLight() {
            return 0;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }
    }
}

