/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.item.IMultiBlockItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.tiles.base.TileEntityBlock;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.material.MapColor;

public final class TileBlockCreator {
    public static TileBlockCreator instance;
    public int index = 0;
    private List<InfoAboutTile<?>> dataInfo = new LinkedList();

    public TileBlockCreator() {
        instance = this;
    }

    public <E extends Enum<E>> BlockTileEntity<E> create(E enumClass, ResourceLocation location) {
        InfoAboutTile<E> instance = new InfoAboutTile<E>(enumClass, this.index);
        BlockTileEntity<E> block = BlockTileEntity.create(enumClass, location, instance);
        instance.setBlock(block);
        this.dataInfo.add(instance);
        ++this.index;
        return block;
    }

    public void buildBlocks() {
        for (InfoAboutTile<?> tile : this.dataInfo) {
            for (IMultiTileBlock multiTileBlock : tile.teBlocks) {
                multiTileBlock.buildDummies();
            }
        }
        this.dataInfo = new ArrayList(this.dataInfo);
    }

    public BlockTileEntity get(int index) {
        return this.dataInfo.get(index).getBlock();
    }

    public List<IMultiTileBlock> getAllTiles() {
        ArrayList<IMultiTileBlock> tileBlocks = new ArrayList<IMultiTileBlock>();
        for (InfoAboutTile<?> tile : this.dataInfo) {
            tileBlocks.addAll(tile.teBlocks);
        }
        return tileBlocks;
    }

    public static class InfoAboutTile<E extends Enum<E>> {
        private final boolean specialModels;
        private final int index;
        private final CreativeModeTab tab;
        private final MapColor defaultMaterial;
        private final List<? extends IMultiTileBlock> listBlock;
        private List<IMultiTileBlock> teBlocks;
        private List<IMultiTileBlock> idMap = new LinkedList<IMultiTileBlock>();
        private BlockTileEntity<E> block;

        InfoAboutTile(E universe, int index) {
            this.index = index;
            this.teBlocks = new LinkedList<IMultiTileBlock>();
            this.specialModels = IMultiBlockItem.class.isAssignableFrom(universe.getClass());
            this.register(universe);
            this.idMap = new ArrayList<IMultiTileBlock>(this.idMap);
            this.teBlocks = new ArrayList<IMultiTileBlock>(this.teBlocks);
            this.defaultMaterial = this.teBlocks.get(0).getMaterial();
            this.tab = this.teBlocks.get(0).getCreativeTab();
            this.listBlock = this.teBlocks;
            this.listBlock.sort((o1, o2) -> {
                if (o1.getId() < o2.getId()) {
                    return -1;
                }
                if (o1.getId() - o2.getId() == 0) {
                    return 0;
                }
                return 1;
            });
        }

        public List<? extends IMultiTileBlock> getListBlock() {
            return this.listBlock;
        }

        public CreativeModeTab getTab() {
            return this.tab;
        }

        public Class<? extends TileEntityBlock> getClassFromName(String name) {
            for (IMultiTileBlock iMultiTileBlock : this.listBlock) {
                if (!iMultiTileBlock.getName().equals(name)) continue;
                return iMultiTileBlock.getTeClass();
            }
            return null;
        }

        void register(E block) {
            this.teBlocks.add((IMultiTileBlock)block);
            ((IMultiTileBlock)block).setIdBlock(this.index);
            if (((ISubEnum)block).getId() > -1) {
                int ID = ((ISubEnum)block).getId();
                while (this.idMap.size() < ID) {
                    this.idMap.add(null);
                }
                if (this.idMap.size() == ID) {
                    this.idMap.add((IMultiTileBlock)block);
                } else {
                    this.idMap.set(ID, (IMultiTileBlock)block);
                }
            }
        }

        public List<IMultiTileBlock> getTeBlocks() {
            return this.teBlocks;
        }

        public BlockTileEntity<E> getBlock() {
            return this.block;
        }

        void setBlock(BlockTileEntity<E> block) {
            this.block = block;
        }

        public MapColor getDefaultMaterial() {
            return this.defaultMaterial;
        }

        public boolean hasSpecialModels() {
            return this.specialModels;
        }

        public List<IMultiTileBlock> getIdMap() {
            return this.idMap;
        }
    }
}

