/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.TileMatter;
import com.denfop.tiles.mechanism.multimechanism.simple.TileCompressor;
import com.denfop.tiles.mechanism.multimechanism.simple.TileElectricFurnace;
import com.denfop.tiles.mechanism.multimechanism.simple.TileExtractor;
import com.denfop.tiles.mechanism.multimechanism.simple.TileMacerator;
import com.denfop.tiles.mechanism.multimechanism.simple.TileRecycler;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum BlockSimpleMachine implements IMultiTileBlock
{
    macerator_iu(TileMacerator.class, 0),
    compressor_iu(TileCompressor.class, 1),
    furnace_iu(TileElectricFurnace.class, 2),
    extractor_iu(TileExtractor.class, 3),
    recycler_iu(TileRecycler.class, 5),
    generator_matter(TileMatter.class, 6);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    int idBlock;
    private TileEntityBlock dummyTe;
    private BlockState defaultState;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockType;

    private BlockSimpleMachine(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = IUCore.instance.modContainer;
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        if (this.getTeClass() != null) {
            try {
                this.dummyTe = (TileEntityBlock)((Object)this.teClass.getConstructors()[0].newInstance(BlockPos.ZERO, this.defaultState));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    @Override
    public void setType(DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    @Override
    public BlockEntityType<? extends TileEntityBlock> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    @Override
    public String getMainPath() {
        return "simplemachine";
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return true;
    }

    @Override
    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    @Override
    public float getHardness() {
        return 3.0f;
    }

    @Override
    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Machine;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }
}

