/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.container;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.inv.VirtualSlot;
import com.denfop.invslot.InvSlot;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class SlotVirtual
extends Slot {
    private final VirtualSlot slotInfo;
    private final int index;

    public SlotVirtual(IAdvInventory inventoryIn, int index, int xPosition, int yPosition, VirtualSlot slotInfo) {
        super((Container)inventoryIn, slotInfo instanceof InvSlot ? inventoryIn.getBaseIndex((InvSlot)((Object)slotInfo)) + index : index, xPosition, yPosition);
        this.slotInfo = slotInfo;
        this.index = index;
    }

    public boolean mayPlace(@NotNull ItemStack itemStack) {
        return this.slotInfo.accepts(itemStack, this.index);
    }

    public int getJeiX() {
        return this.x - 1;
    }

    public int getJeiY() {
        return this.y - 1;
    }

    @NotNull
    public ItemStack getItem() {
        return this.slotInfo.get(this.index);
    }

    public void set(@NotNull ItemStack itemStack) {
        super.set(itemStack);
    }

    public boolean mayPickup(Player p_40228_) {
        return false;
    }

    public void slotClick(int slotId, int dragType, ClickType clickType, Player player) {
        ItemStack itemstack12 = player.containerMenu.getCarried();
        if (!itemstack12.isEmpty()) {
            if (!this.slotInfo.isFluid()) {
                ItemStack stack = itemstack12.copy();
                stack.setCount(1);
                if (this.mayPlace(stack)) {
                    this.set(stack);
                }
            } else {
                FluidStack containerFluid;
                itemstack12 = itemstack12.copy();
                itemstack12.setCount(1);
                IFluidHandlerItem handler = null;
                try {
                    handler = (IFluidHandlerItem)itemstack12.getCapability(Capabilities.FluidHandler.ITEM, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (handler != null && !(containerFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && containerFluid.getAmount() > 0) {
                    this.container.setItem(this.getSlotIndex(), itemstack12);
                    if (this.slotInfo.getFluidStackList() == null || this.slotInfo.getFluidStackList().isEmpty()) {
                        this.slotInfo.setFluidList(new ArrayList<Object>(Collections.nCopies(this.slotInfo.size(), null)));
                    }
                    this.slotInfo.getFluidStackList().set(this.index, containerFluid);
                }
            }
        } else {
            Block block;
            if (this.slotInfo.isFluid() && (block = Block.byItem((Item)this.slotInfo.get(this.index).getItem())) != Blocks.AIR) {
                this.slotInfo.getFluidStackList().set(this.index, null);
            }
            this.set(itemstack12);
        }
        this.setChanged();
    }
}

