/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datacomponent;

import com.denfop.datacomponent.ContainerItem;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ReactorSchedule(int type, int level, String name, int generation, int rad, List<ItemStack> items, List<Integer> gridLayout) {
    public static final Codec<ReactorSchedule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("type").forGetter(ReactorSchedule::type), (App)Codec.INT.fieldOf("level").forGetter(ReactorSchedule::level), (App)Codec.STRING.fieldOf("name").forGetter(ReactorSchedule::name), (App)Codec.INT.fieldOf("generation").forGetter(ReactorSchedule::generation), (App)Codec.INT.fieldOf("rad").forGetter(ReactorSchedule::rad), (App)ContainerItem.CUSTOM_ITEMSTACK_CODEC.listOf().fieldOf("items").forGetter(ReactorSchedule::items), (App)Codec.INT.listOf().fieldOf("grid").forGetter(ReactorSchedule::gridLayout)).apply((Applicative)instance, ReactorSchedule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReactorSchedule> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        buf.writeInt(value.type());
        buf.writeInt(value.level());
        buf.writeUtf(value.name());
        buf.writeInt(value.generation());
        buf.writeInt(value.rad());
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer((RegistryFriendlyByteBuf)buf);
        try {
            EncoderHandler.encode(packetBuffer, value.items);
            EncoderHandler.encode(packetBuffer, value.gridLayout);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }, buf -> {
        int type = buf.readInt();
        int level = buf.readInt();
        String name = buf.readUtf();
        int generation = buf.readInt();
        int rad = buf.readInt();
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer((RegistryFriendlyByteBuf)buf);
        ArrayList<ItemStack> itemsList = new ArrayList();
        ArrayList<Integer> grid = new ArrayList();
        try {
            itemsList = (List)DecoderHandler.decode(packetBuffer);
            grid = (List)DecoderHandler.decode(packetBuffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ReactorSchedule(type, level, name, generation, rad, itemsList, grid);
    });
}

