/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datacomponent;

import com.denfop.api.space.upgrades.info.SpaceUpgradeItemInform;
import com.denfop.datacomponent.DataComponentsInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record UpgradeRover(List<SpaceUpgradeItemInform> upgradeItemInforms, boolean isRegistry, int amount, boolean canupgrade) {
    public static final Codec<UpgradeRover> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceUpgradeItemInform.CODEC.listOf().fieldOf("upgradeItemInforms").forGetter(UpgradeRover::upgradeItemInforms), (App)Codec.BOOL.fieldOf("isRegistry").forGetter(UpgradeRover::isRegistry), (App)Codec.INT.fieldOf("amount").forGetter(UpgradeRover::amount), (App)Codec.BOOL.fieldOf("canUpgrade").forGetter(UpgradeRover::canupgrade)).apply((Applicative)instance, UpgradeRover::new));
    public static final StreamCodec<FriendlyByteBuf, UpgradeRover> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        buf.writeCollection(value.upgradeItemInforms(), (b, v) -> SpaceUpgradeItemInform.STREAM_CODEC.encode(b, v));
        buf.writeBoolean(value.isRegistry());
        buf.writeInt(value.amount());
        buf.writeBoolean(value.isRegistry());
    }, buf -> {
        UpgradeRover upgradeItem = new UpgradeRover(buf.readList(arg_0 -> SpaceUpgradeItemInform.STREAM_CODEC.decode(arg_0)), buf.readBoolean(), buf.readInt(), buf.readBoolean());
        return upgradeItem;
    });
    public static UpgradeRover EMPTY = new UpgradeRover(new ArrayList<SpaceUpgradeItemInform>(), false, 0, true);

    public UpgradeRover copy() {
        return new UpgradeRover(new ArrayList<SpaceUpgradeItemInform>(), false, 0, true);
    }

    public UpgradeRover updateUpgrades(ItemStack stack, List<SpaceUpgradeItemInform> upgradeItemInforms) {
        UpgradeRover updated = new UpgradeRover(upgradeItemInforms, this.isRegistry, this.amount, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ROVER.get(), (Object)updated);
        return updated;
    }

    public UpgradeRover updateRegistry(ItemStack stack, boolean isRegistry) {
        UpgradeRover updated = new UpgradeRover(this.upgradeItemInforms, isRegistry, this.amount, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ROVER.get(), (Object)updated);
        return updated;
    }

    public UpgradeRover updateAmount(ItemStack stack, int amount) {
        UpgradeRover updated = new UpgradeRover(this.upgradeItemInforms, this.isRegistry, amount, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ROVER.get(), (Object)updated);
        return updated;
    }

    public UpgradeRover updateCanUpgrade(ItemStack stack, boolean canupgrade) {
        UpgradeRover updated = new UpgradeRover(this.upgradeItemInforms, this.isRegistry, this.amount, canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ROVER.get(), (Object)updated);
        return updated;
    }
}

