/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.container.ContainerAgriculturalAnalyzer;
import com.denfop.gui.GuiIU;
import com.denfop.items.crop.ItemStackAgriculturalAnalyzer;
import com.denfop.utils.Timer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiAgriculturalAnalyzer<T extends ContainerAgriculturalAnalyzer>
extends GuiIU<ContainerAgriculturalAnalyzer> {
    private static ResourceLocation background = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guicropanalyzer.png");
    private final String name;
    private int prevText;
    private float scaled;
    private int textIndex;

    public GuiAgriculturalAnalyzer(ContainerAgriculturalAnalyzer container, ItemStack itemStack1) {
        super(container);
        this.name = Localization.translate(itemStack1.getDescriptionId());
        this.componentList.clear();
        this.imageWidth = 203;
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.crop.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 16; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.crop.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 160, mouseY - 10, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        GuiAgriculturalAnalyzer.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        poseStack.drawString(Minecraft.getInstance().font, this.name, (this.imageWidth - this.getStringWidth(this.name)) / 2 - 10, 4, 0, false);
        if (!((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).get(0).isEmpty() && ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).genome == null) {
            ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).genome = new Genome(((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).get(0));
            ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).crop = CropNetwork.instance.getCropFromStack(((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).get(0)).copy();
            ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).genome.loadCrop(((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).crop);
            this.textIndex = 0;
        } else if (((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).get(0).isEmpty() && ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).genome != null) {
            ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).genome = null;
            ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).crop = null;
            this.textIndex = 0;
        }
        if (((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).genome != null) {
            String text = this.getInformationFromCrop();
            int canvasX = 13;
            int canvasY = 19;
            int canvasWidth = 150;
            int canvasHeight = 112;
            float scale = 0.5f;
            int maxWidth = (int)((float)canvasWidth / scale);
            Objects.requireNonNull(this.font);
            double lineHeight = 9.0 * 0.5;
            int x = canvasX;
            double y = canvasY;
            PoseStack pose = poseStack.pose();
            List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
            for (String line : lines) {
                if (y + lineHeight > (double)(canvasY + canvasHeight)) break;
                pose.pushPose();
                pose.translate((double)x, y, 0.0);
                pose.scale(scale, scale, scale);
                poseStack.drawString(this.font, line, 0, 0, 0xFFFFFF, false);
                pose.popPose();
                y += lineHeight;
            }
        }
    }

    private String getInformationFromCrop() {
        ICrop crop = ((ItemStackAgriculturalAnalyzer)((ContainerAgriculturalAnalyzer)this.container).base).crop;
        ArrayList namesBiomes = new ArrayList();
        crop.getBiomes().forEach(biomeKey -> namesBiomes.add(Localization.translate("biome." + biomeKey.location().getNamespace() + "." + biomeKey.location().getPath())));
        return Localization.translate("iu.crop_analyzer.name") + Localization.translate("crop." + crop.getName()) + "\n" + Localization.translate("iu.crop_analyzer.grow_time") + new Timer(crop.getMaxTick() / 20).getDisplay() + "\n" + Localization.translate("iu.crop_analyzer.yield") + crop.getYield() + "\n" + Localization.translate("iu.crop_analyzer.drop") + crop.getDrops().get(0).getDisplayName().getString() + "\n" + Localization.translate("iu.crop_analyzer.soil") + crop.getSoil().getStack().getDisplayName().getString() + "\n" + Localization.translate("iu.crop_analyzer.daytime") + (crop.isSun() ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.crop_analyzer.nighttime") + (crop.isNight() ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.crop_analyzer.grow_speed") + crop.getGrowthSpeed() + "t \n" + Localization.translate("iu.crop_analyzer.min_light_level") + crop.getLightLevel() + "\n" + Localization.translate("iu.crop_analyzer.max_soil_pollution") + crop.getSoilRequirements().name() + "\n" + Localization.translate("iu.crop_analyzer.max_air_pollution") + crop.getAirRequirements().name() + "\n" + Localization.translate("iu.crop_analyzer.max_radiation_pollution") + crop.getRadiationRequirements().name() + "\n" + Localization.translate("iu.crop_analyzer.chance_weed") + (100 - crop.getChanceWeed()) + "%\n" + Localization.translate("iu.crop_analyzer.pest_resistance") + crop.getPestResistance() + "%\n" + Localization.translate("iu.crop_analyzer.ignore_soil") + (crop.isIgnoreSoil() ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.crop_analyzer.weather_resistance") + (crop.getWeatherResistance() == 0 ? Localization.translate("iu.space_no") : (crop.getWeatherResistance() == 1 ? Localization.translate("iu.space_rain") : Localization.translate("iu.space_thunder"))) + "\n" + Localization.translate("iu.crop_analyzer.percent_genome_adaptive") + Math.max(5, crop.getGenomeAdaptive()) + "%\n" + Localization.translate("iu.crop_analyzer.percent_genome_resistance") + Math.max(5, crop.getGenomeResistance()) + "%\n" + Localization.translate("iu.crop_analyzer.water_requirement") + (String)(crop.getWaterRequirement() == 0 ? Localization.translate("iu.space_no") : crop.getWaterRequirement() + " blocks") + "\n" + Localization.translate("iu.crop_analyzer.biomes") + namesBiomes.stream().collect(Collectors.joining(", "));
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

