/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerFisher;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileFisher;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiFisher<T extends ContainerFisher>
extends GuiIU<ContainerFisher> {
    public final ContainerFisher container;

    public GuiFisher(ContainerFisher container1) {
        super(container1);
        this.container = container1;
        this.addComponent(new GuiComponent(this, 5, 20, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.addComponent(new GuiComponent(this, 146, 28, EnumTypeComponent.ENERGY_HEIGHT, new Component<Energy>(((TileFisher)this.container.base).energy)));
        this.addComponent(new GuiComponent(this, 41, 45, EnumTypeComponent.PROGRESS4, new Component<1>(new ComponentProgress((TileEntityInventory)this.container.base, 1, 0){

            @Override
            public double getBar() {
                return (double)((TileFisher)GuiFisher.this.container.base).progress / 100.0;
            }
        })));
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        this.drawForeground(poseStack, par1, par2);
        this.draw(poseStack, this.getName(), (int)((float)(this.imageWidth - this.getStringWidth(this.getName())) / 2.0f), 6, 0x404040);
        this.handleUpgradeTooltip(par1, par2);
        String tooltip2 = ModUtils.getString(Math.min(((TileFisher)this.container.base).energy.getEnergy(), ((TileFisher)this.container.base).energy.getCapacity())) + "/" + ModUtils.getString(((TileFisher)this.container.base).energy.getCapacity()) + " EF";
        String tooltip = ModUtils.getString(Math.min(((TileFisher)this.container.base).progress, 100)) + "%";
        ((Area)new AdvArea(this, 147, 27, 158, 76).withTooltip(tooltip2)).drawForeground(poseStack, par1, par2);
        ((Area)new AdvArea(this, 41, 45, 55, 60).withTooltip(tooltip)).drawForeground(poseStack, par1, par2);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.fisherinformation"));
            List<String> compatibleUpgrades = ListInformationUtils.fisherinform;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        GuiFisher.bindTexture(this.getTexture());
        this.drawTexturedModalRect(poseStack, this.guiLeft(), this.guiTop(), 0, 0, this.imageWidth, this.imageHeight);
        this.drawBackground(poseStack);
        GuiFisher.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft() + 3, this.guiTop() + 3, 0, 0, 10, 10);
        GuiFisher.bindTexture(this.getTexture());
        int chargeLevel = (int)(48.0 * ((TileFisher)this.container.base).energy.getEnergy() / ((TileFisher)this.container.base).energy.getCapacity());
        int progress = 15 * ((TileFisher)this.container.base).progress / 100;
        if (chargeLevel > 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft() + 140 + 1 + 5, this.guiTop() + 28 + 48 - chargeLevel, 176, 48 - chargeLevel, 48, chargeLevel);
        }
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft() + 42, this.guiTop() + 46, 177, 48, progress + 1, 14);
        }
    }

    public String getName() {
        return Localization.translate(((TileFisher)this.container.base).getName());
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }
}

