/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.extruder;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ExtruderHandler {
    private static final List<ExtruderHandler> recipes = new ArrayList<ExtruderHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public ExtruderHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.container = container;
    }

    public static List<ExtruderHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ExtruderHandler.initRecipes();
        }
        return recipes;
    }

    public static ExtruderHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        ExtruderHandler recipe = new ExtruderHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ExtruderHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (ExtruderHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("extruding")) {
            try {
                ExtruderHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
            }
            catch (Exception ignored) {
                System.out.println(2);
            }
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return is.getItem() == this.input.getItem();
    }
}

