/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.genobs;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class GenObsHandler {
    private static final List<GenObsHandler> recipes = new ArrayList<GenObsHandler>();
    private final FluidStack input2;
    private final FluidStack input;
    private final ItemStack output;

    public GenObsHandler(FluidStack input, FluidStack input2, ItemStack output) {
        this.input = input;
        this.input2 = input2;
        this.output = output;
    }

    public static List<GenObsHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GenObsHandler.initRecipes();
        }
        return recipes;
    }

    public static GenObsHandler addRecipe(FluidStack input, FluidStack input2, ItemStack output) {
        GenObsHandler recipe = new GenObsHandler(input, input2, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static GenObsHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        Iterator<GenObsHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            GenObsHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe container : Recipes.recipes.getRecipeFluid().getRecipeList("obsidian")) {
            GenObsHandler.addRecipe(container.getInput().getInputs().get(0), container.getInput().getInputs().get(1), container.getOutput().items.get(0));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getInput1() {
        return this.input2;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

