/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.inoculator;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class InoculatorHandler {
    private static final List<InoculatorHandler> recipes = new ArrayList<InoculatorHandler>();
    public final ItemStack input;
    public final ItemStack input1;
    public final ItemStack output;

    public InoculatorHandler(ItemStack input, ItemStack input1, ItemStack output) {
        this.input = input;
        this.input1 = input1;
        this.output = output;
    }

    public static List<InoculatorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            InoculatorHandler.initRecipes();
        }
        return recipes;
    }

    public static InoculatorHandler addRecipe(ItemStack input, ItemStack input1, ItemStack output) {
        InoculatorHandler recipe = new InoculatorHandler(input, input1, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static InoculatorHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (InoculatorHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("inoculator")) {
            InoculatorHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

