/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.mattery_factory;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class MatteryHandler {
    private static final List<MatteryHandler> recipes = new ArrayList<MatteryHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public MatteryHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<MatteryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            MatteryHandler.initRecipes();
        }
        return recipes;
    }

    public static MatteryHandler addRecipe(ItemStack input, ItemStack output) {
        MatteryHandler recipe = new MatteryHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static MatteryHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (MatteryHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("active_matter_factory")) {
            MatteryHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

