/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.probeassembler;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ProbeAssemblerHandler {
    private static final List<ProbeAssemblerHandler> recipes = new ArrayList<ProbeAssemblerHandler>();
    private final List<ItemStack> input;
    ItemStack output;

    public ProbeAssemblerHandler(List<ItemStack> input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<ProbeAssemblerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ProbeAssemblerHandler.initRecipes();
        }
        return recipes;
    }

    public static ProbeAssemblerHandler addRecipe(List<ItemStack> input, ItemStack output) {
        ProbeAssemblerHandler recipe = new ProbeAssemblerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("probeassembler")) {
            ProbeAssemblerHandler.addRecipe(container.input.getStackInputs(), container.getOutput().items.get(0));
        }
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }
}

