/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.scrap;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ScrapHandler {
    private static final List<ScrapHandler> recipes = new ArrayList<ScrapHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public ScrapHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<ScrapHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ScrapHandler.initRecipes();
        }
        return recipes;
    }

    public static ScrapHandler addRecipe(ItemStack input, ItemStack output) {
        ScrapHandler recipe = new ScrapHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ScrapHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (ScrapHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("scrap")) {
            ScrapHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return is.getItem() == this.input.getItem();
    }
}

