/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.blocks.ISubEnum;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.ReactorSchedule;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemCraftingElements;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InvSlotScheduleReactor
extends InvSlot {
    private final int type;
    private final int level;
    private final int x;
    private final int y;
    Map<Integer, ItemStack> accepts = new HashMap<Integer, ItemStack>();

    public InvSlotScheduleReactor(IAdvInventory<?> base, int type, int level, int x, int y) {
        super(base, InvSlot.TypeItemSlot.INPUT_OUTPUT, 1);
        this.type = type;
        this.level = level;
        this.x = x;
        this.y = y;
    }

    public Map<Integer, ItemStack> getAccepts() {
        return this.accepts;
    }

    @Override
    public int getStackSizeLimit() {
        return 1;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        Item item = stack.getItem();
        if (item instanceof ItemCraftingElements) {
            if (((ISubEnum)((ItemCraftingElements)item).getElement()).getId() == 143 && stack.has(DataComponentsInit.REACTOR_SCHEDULE)) {
                ReactorSchedule reactorSchedule = (ReactorSchedule)stack.get(DataComponentsInit.REACTOR_SCHEDULE);
                return this.type == reactorSchedule.type() && this.level == reactorSchedule.level();
            }
            return false;
        }
        return false;
    }

    @Override
    public void update() {
        this.accepts.clear();
        if (!this.get(0).isEmpty()) {
            ReactorSchedule reactorSchedule = (ReactorSchedule)this.get(0).get(DataComponentsInit.REACTOR_SCHEDULE);
            for (int y = 0; y < this.y; ++y) {
                for (int x = 0; x < this.x; ++x) {
                    ItemStack itemStack = reactorSchedule.items().get(y * this.x + x);
                    if (itemStack.isEmpty()) {
                        this.accepts.put(y * this.x + x, ItemStack.EMPTY);
                        continue;
                    }
                    this.accepts.put(y * this.x + x, itemStack);
                }
            }
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.accepts = new HashMap<Integer, ItemStack>();
        if (!content.isEmpty()) {
            ReactorSchedule reactorSchedule = (ReactorSchedule)content.get(DataComponentsInit.REACTOR_SCHEDULE);
            for (int y = 0; y < this.y; ++y) {
                for (int x = 0; x < this.x; ++x) {
                    ItemStack itemStack = reactorSchedule.items().get(y * this.x + x);
                    if (itemStack.isEmpty()) {
                        this.accepts.put(y * this.x + x, ItemStack.EMPTY);
                        continue;
                    }
                    this.accepts.put(y * this.x + x, itemStack);
                }
            }
        }
        return content;
    }
}

