/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.blocks.ISubEnum;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemWindRod;
import com.denfop.items.ItemWindRotor;
import com.denfop.tiles.windturbine.TileEntityWindTurbineController;
import net.minecraft.world.item.ItemStack;

public class InvSlotTurbineRotorBlades
extends InvSlot
implements ITypeSlot {
    private final TileEntityWindTurbineController windGenerator;

    public InvSlotTurbineRotorBlades(TileEntityWindTurbineController windGenerator) {
        super(windGenerator, InvSlot.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(64);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.ROD_PART;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        if (this.windGenerator.getRotor() == null) {
            return false;
        }
        if (this.windGenerator.getRotor() != null && stack.getItem() instanceof ItemWindRod) {
            return ((ItemWindRod)stack.getItem()).getLevel(this.windGenerator.getRotor().getLevel(), ((ISubEnum)((ItemWindRod)stack.getItem()).getElement()).getId());
        }
        return false;
    }

    public void consume(int amount) {
        this.consume(amount, false);
    }

    public void work() {
        if (this.get(0).isEmpty()) {
            return;
        }
        ItemStack stack = this.windGenerator.slot.get(0);
        if (this.windGenerator.getRotor() != null && this.get(0).getItem() instanceof ItemWindRod && ((ItemWindRod)this.get(0).getItem()).getLevel(this.windGenerator.getRotor().getLevel(), ((ISubEnum)((ItemWindRod)this.get(0).getItem()).getElement()).getId()) && (double)((ItemWindRotor)stack.getItem()).getCustomDamage(stack) <= (double)((ItemWindRotor)stack.getItem()).getMaxCustomDamage(stack) * 0.75) {
            this.windGenerator.slot.damage((int)((double)(-1 * ((ItemWindRotor)stack.getItem()).getMaxCustomDamage(stack)) * 0.25), 0.0);
            this.get(0).shrink(1);
        }
    }

    public void consume(int amount, boolean simulate) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (stack.isEmpty() || amount <= 0) continue;
            int currentAmount = Math.min(amount, stack.getCount());
            if (!simulate) {
                stack.shrink(currentAmount);
            }
            if ((amount -= currentAmount) == 0) break;
        }
    }
}

