/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.tiles.base.TileEntityTeleporter;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemFrequencyTransmitter
extends Item
implements IItemTab {
    private String nameItem;

    public ItemFrequencyTransmitter() {
        super(new Item.Properties());
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hadJustSet;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isShiftKeyDown() && (hadJustSet = stack.has(DataComponentsInit.TELEPORT))) {
            stack.remove(DataComponentsInit.TELEPORT);
            player.displayClientMessage((Component)Component.translatable((String)"Frequency Transmitter unlinked"), true);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (level.isClientSide || player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof TileEntityTeleporter)) {
            return InteractionResult.PASS;
        }
        TileEntityTeleporter teleporter = (TileEntityTeleporter)blockEntity;
        boolean targetSet = stack.has(DataComponentsInit.TELEPORT);
        BlockPos target = (BlockPos)stack.getOrDefault(DataComponentsInit.TELEPORT, (Object)BlockPos.ZERO);
        if (!targetSet) {
            target = teleporter.getPos();
            stack.set(DataComponentsInit.TELEPORT, (Object)target);
            player.displayClientMessage((Component)Component.translatable((String)"Frequency Transmitter linked to Teleporter."), true);
        } else if (teleporter.getPos().equals((Object)target)) {
            player.displayClientMessage((Component)Component.translatable((String)"Can't link Teleporter to itself."), true);
        } else if (teleporter.hasTarget() && teleporter.getTarget().equals((Object)target)) {
            player.displayClientMessage((Component)Component.translatable((String)"Teleportation link unchanged."), true);
        } else {
            BlockEntity targetEntity = level.getBlockEntity(target);
            if (targetEntity instanceof TileEntityTeleporter) {
                TileEntityTeleporter targetTeleporter = (TileEntityTeleporter)targetEntity;
                teleporter.setTarget(target);
                targetTeleporter.setTarget(pos);
                player.displayClientMessage((Component)Component.translatable((String)"Teleportation link established."), true);
            }
        }
        stack.set(DataComponentsInit.TELEPORT, (Object)target);
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.has(DataComponentsInit.TELEPORT)) {
            BlockPos pos = (BlockPos)stack.get(DataComponentsInit.TELEPORT);
            tooltip.add((Component)Component.translatable((String)"frequency_transmitter.tooltip.target", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"frequency_transmitter.tooltip.blank"));
        }
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item.frequency_transmitter";
        }
        return this.nameItem;
    }
}

