/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.api.item.IEnergyItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.armour.ItemArmorUtility;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemArmorNightvisionGoggles
extends ItemArmorUtility
implements IEnergyItem {
    public ItemArmorNightvisionGoggles() {
        super("nightvision", ArmorItem.Type.HELMET);
        this.armorName = "nightvision_goggles";
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ItemStack var4 = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            p_41392_.add((Object)var4);
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)("Nightvision Key: " + KeyboardClient.armormode.getKey().getDisplayName().getString())));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return 200000.0;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return 200.0;
    }

    @Override
    public void inventoryTick(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (p_41407_ >= 36 && p_41407_ < 40 && p_41406_ instanceof Player) {
            Player player = (Player)p_41406_;
            this.onArmorTick(p_41404_, p_41405_, (Player)p_41406_);
        }
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (world.isClientSide) {
            return;
        }
        CompoundTag nbtData = ModUtils.nbt(stack);
        boolean active = (Boolean)stack.getOrDefault(DataComponentsInit.NIGHT_VISION, (Object)false);
        byte toggleTimer = nbtData.getByte("toggleTimer");
        if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = active = !active;
            if (!player.level().isClientSide()) {
                stack.set(DataComponentsInit.NIGHT_VISION, (Object)active);
                if (active) {
                    IUCore.proxy.messagePlayer(player, "Nightvision enabled.");
                } else {
                    IUCore.proxy.messagePlayer(player, "Nightvision disabled.");
                }
            }
        }
        if (!player.level().isClientSide() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.putByte("toggleTimer", toggleTimer);
        }
        boolean ret = false;
        if (active && !player.level().isClientSide() && ElectricItem.manager.use(stack, 1.0, (LivingEntity)player)) {
            int skylight = player.level().getMaxLocalRawBrightness(player.blockPosition());
            if (skylight > 8) {
                IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)MobEffects.NIGHT_VISION);
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0, true, true));
            } else {
                IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)MobEffects.BLINDNESS);
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0, true, true));
            }
            ret = true;
        }
        if (ret) {
            player.containerMenu.broadcastChanges();
        }
    }
}

