/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.proxy.CommonProxy;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class ItemLappack
extends ItemArmorEnergy
implements IEnergyItem,
ISpecialArmor,
IUpgradeItem,
IProperties {
    private final double maxCharge;
    private final double transferLimit;
    private final int tier;
    private final String name;

    public ItemLappack(String name, double MaxCharge, int Tier2, double TransferLimit) {
        super("", ArmorItem.Type.CHESTPLATE, MaxCharge, TransferLimit, Tier2);
        this.maxCharge = MaxCharge;
        this.transferLimit = TransferLimit;
        this.name = name;
        this.tier = Tier2;
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.LAPPACK.list));
    }

    public static int readToolMode(ItemStack itemstack) {
        CompoundTag nbttagcompound = ModUtils.nbt(itemstack);
        int toolMode = nbttagcompound.getInt("toolMode");
        if (toolMode < 0 || toolMode > 1) {
            toolMode = 0;
        }
        return toolMode;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ItemStack var4 = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            p_41392_.add((Object)var4);
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level worldIn, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(stack, worldIn, p_41406_, p_41407_, p_41408_);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(worldIn, this, stack));
        }
        if (p_41407_ >= 36 && p_41407_ < 40 && p_41406_ instanceof Player) {
            Player player = (Player)p_41406_;
            this.onArmorTick(stack, worldIn, (Player)p_41406_);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.4;
    }

    @Override
    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        CompoundTag nbtData = ModUtils.nbt(stack);
        if (!nbtData.getString("mode").isEmpty()) {
            return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.name + "_" + nbtData.getString("mode") + ".png"));
        }
        return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.name + ".png"));
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / ((double)energyPerDamage - (double)(energyPerDamage * protect) * 0.2) : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getEnergyPerDamage() {
        return (int)(this.maxCharge * 0.05);
    }

    @Override
    public int getArmorDisplay(Player player, @Nonnull ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        CompoundTag nbttagcompound = ModUtils.nbt(itemstack);
        nbttagcompound.putInt("toolMode", toolMode.intValue());
    }

    public InteractionResultHolder<ItemStack> use(Level p_41432_, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int toolMode = ItemLappack.readToolMode(itemStack);
            if (++toolMode > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0 && !p_41432_.isClientSide) {
                CommonProxy.sendPlayerMessage(player, String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.message.text.powerSupply") + " " + String.valueOf(ChatFormatting.RED) + Localization.translate("iu.message.text.disabled"));
            }
            if (toolMode == 1 && !p_41432_.isClientSide) {
                CommonProxy.sendPlayerMessage(player, String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.message.text.powerSupply") + " " + String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.message.text.enabled"));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }

    public void appendHoverText(ItemStack par1ItemStack, @Nullable Item.TooltipContext p_41422_, List<Component> par3List, TooltipFlag p_41424_) {
        super.appendHoverText(par1ItemStack, p_41422_, par3List, p_41424_);
        int toolMode = ItemLappack.readToolMode(par1ItemStack);
        par3List.add((Component)Component.literal((String)Localization.translate("iu.lappack.info")));
        if (toolMode == 0) {
            par3List.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.message.text.powerSupply") + ": " + String.valueOf(ChatFormatting.RED) + Localization.translate("iu.message.text.disabled"))));
        }
        if (toolMode == 1) {
            par3List.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.message.text.powerSupply") + ": " + String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.message.text.enabled"))));
        }
        if (!KeyboardIU.isKeyDown(340)) {
            par3List.add((Component)Component.literal((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            par3List.add((Component)Component.literal((String)(Localization.translate("iu.changemode_key") + KeyboardClient.changemode.getKey().getDisplayName().getString() + " + " + Localization.translate("iu.changemode_rcm1"))));
        }
    }

    public void onArmorTick(ItemStack itemStack, Level world, Player player) {
        int toolMode;
        if (world.isClientSide) {
            return;
        }
        CompoundTag nbtData = ModUtils.nbt(itemStack);
        byte toggleTimer = nbtData.getByte("toggleTimer");
        if (IUCore.keyboard.isChangeKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            toolMode = ItemLappack.readToolMode(itemStack);
            if (++toolMode > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                CommonProxy.sendPlayerMessage(player, String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.message.text.powerSupply") + " " + String.valueOf(ChatFormatting.RED) + Localization.translate("iu.message.text.disabled"));
            }
            if (toolMode == 1) {
                CommonProxy.sendPlayerMessage(player, String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.message.text.powerSupply") + " " + String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.message.text.enabled"));
            }
        }
        if (!player.level().isClientSide() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.putByte("toggleTimer", toggleTimer);
        }
        toolMode = ItemLappack.readToolMode(itemStack);
        boolean ret = false;
        double energy3 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.LAPPACK_ENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.LAPPACK_ENERGY, (ItemStack)itemStack).number : 0;
        if (energy3 != 0.0) {
            energy3 *= 0.005;
        }
        if (toolMode == 1) {
            int resistance;
            double sentPacket;
            for (int i = 0; i < player.getInventory().armor.size(); ++i) {
                if (((ItemStack)player.getInventory().armor.get(i)).isEmpty() || !(((ItemStack)player.getInventory().armor.get(i)).getItem() instanceof IEnergyItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0) || itemStack.is(((ItemStack)player.getInventory().armor.get(i)).getItem()) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.getInventory().armor.get(i), ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                ret = true;
            }
            for (int j = 0; j < player.getInventory().items.size(); ++j) {
                if (((ItemStack)player.getInventory().items.get(j)).isEmpty() || !(((ItemStack)player.getInventory().items.get(j)).getItem() instanceof IEnergyItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.getInventory().items.get(j), ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                ret = true;
            }
            boolean fireResistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack);
            if (fireResistance) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300));
            }
            int n = resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
            if (resistance != 0) {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, resistance));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
                player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 300));
            }
            if (ret) {
                player.containerMenu.broadcastChanges();
            }
        }
    }

    @Override
    public String[] properties() {
        return new String[]{"", "Demon", "Dark", "Cold", "Ender"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(stack);
        return nbt.getString("mode").equals(property) ? 1.0f : 0.0f;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.LAPPACK.list;
    }
}

