/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour.special;

import com.denfop.ElectricItem;
import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.audio.SoundHandler;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.special.EnumCapability;
import com.denfop.items.armour.special.EnumSubTypeArmor;
import com.denfop.items.armour.special.EnumTypeArmor;
import com.denfop.items.armour.special.ItemStackLegsBags;
import com.denfop.items.armour.special.ItemStackStreakSettings;
import com.denfop.items.bags.BagsDescription;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.Register;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.ModUtils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSpecialArmor
extends ArmorItem
implements ISpecialArmor,
IItemStackInventory,
IEnergyItem,
IUpgradeItem,
IItemTab {
    protected final Map<Holder<MobEffect>, Integer> potionRemovalCost = new IdentityHashMap<Holder<MobEffect>, Integer>();
    private final List<EnumCapability> listCapability;
    private final double maxCharge;
    private final int tier;
    private final double transferLimit;
    private final EnumTypeArmor armor;
    private final String name;
    private float jumpCharge;
    private boolean lastJetpackUsed = false;
    private String nameItem;

    public ItemSpecialArmor(EnumSubTypeArmor subTypeArmor, EnumTypeArmor typeArmor) {
        super(Register.ENERGY_ITEM, subTypeArmor.getEntityType(), new Item.Properties().stacksTo(1).setNoRepair());
        ArrayList<EnumCapability> list = new ArrayList<EnumCapability>(subTypeArmor.getCapabilities());
        list.removeIf(capability -> !typeArmor.getListCapability().contains(capability));
        this.listCapability = list;
        if (this.getEquipmentSlot() == EquipmentSlot.FEET) {
            NeoForge.EVENT_BUS.register((Object)this);
        }
        this.armor = typeArmor;
        this.name = typeArmor.name().toLowerCase() + "_" + subTypeArmor.name().toLowerCase();
        this.maxCharge = typeArmor.getMaxEnergy();
        this.tier = typeArmor.getTier();
        this.transferLimit = typeArmor.getMaxTransfer();
        if (this.listCapability.contains((Object)EnumCapability.ACTIVE_EFFECT) || this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
            this.potionRemovalCost.put((Holder<MobEffect>)IUPotion.rad, 20);
            if (this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.POISON, 100);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.WITHER, 100);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.HUNGER, 200);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 200);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.UNLUCK, 200);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.LEVITATION, 200);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.CONFUSION, 200);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.BLINDNESS, 200);
                this.potionRemovalCost.put((Holder<MobEffect>)MobEffects.WEAKNESS, 200);
            }
        }
        switch (this.getEquipmentSlot()) {
            case HEAD: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.HELMET.list));
                break;
            }
            case CHEST: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BODY.list));
                break;
            }
            case LEGS: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.LEGGINGS.list));
                break;
            }
            case FEET: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BOOTS.list));
            }
        }
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        switch (this.getEquipmentSlot()) {
            case HEAD: {
                return EnumUpgrades.HELMET.list;
            }
            case CHEST: {
                return EnumUpgrades.BODY.list;
            }
            case LEGS: {
                return EnumUpgrades.LEGGINGS.list;
            }
            case FEET: {
                return EnumUpgrades.BOOTS.list;
            }
        }
        return EnumUpgrades.HELMET.list;
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        if (this.getEquipmentSlot() == EquipmentSlot.LEGS) {
            return new ItemStackLegsBags(player, stack);
        }
        return new ItemStackStreakSettings(player, stack);
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public EnumTypeArmor getArmor() {
        return this.armor;
    }

    public List<EnumCapability> getListCapability() {
        return this.listCapability;
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity p_41406_, int p_41407_, boolean p_41408_) {
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
        if (p_41407_ >= 36 && p_41407_ < 40 && p_41406_ instanceof Player) {
            Player player = (Player)p_41406_;
            this.onArmorTick(itemStack, world, (Player)p_41406_);
        }
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        int suffix = this.getEquipmentSlot() == EquipmentSlot.LEGS ? 2 : 1;
        CompoundTag nbtData = ModUtils.nbt(stack);
        String mode = nbtData.getString("mode");
        if (!mode.isEmpty() && this.armor.getSkinsList().contains(mode)) {
            if (suffix == 1) {
                return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_" + mode.toLowerCase() + "_1.png"));
            }
            return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_" + mode.toLowerCase() + "_2.png"));
        }
        if (suffix == 1) {
            return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_1.png"));
        }
        return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_2.png"));
    }

    @SubscribeEvent
    public void Potion(EntityTickEvent.Pre event) {
        Item item;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide) {
            return;
        }
        CompoundTag nbtData = player.getPersistentData();
        ItemStack boots = (ItemStack)player.getInventory().armor.get(0);
        boolean hasStepCap = false;
        if (!boots.isEmpty() && (item = boots.getItem()) instanceof ItemSpecialArmor) {
            ItemSpecialArmor armor = (ItemSpecialArmor)item;
            hasStepCap = armor.listCapability.contains((Object)EnumCapability.AUTO_JUMP);
        }
        if (hasStepCap) {
            if (!nbtData.getBoolean("stepHeight")) {
                nbtData.putBoolean("stepHeight", true);
                player.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
            }
        } else if (nbtData.getBoolean("stepHeight")) {
            nbtData.putBoolean("stepHeight", false);
            player.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(0.0);
        }
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void moveRelative(Player player, float strafe, float up, float forward, float friction) {
        float f = strafe * strafe + up * up + forward * forward;
        if (f >= 1.0E-4f) {
            if ((f = Mth.sqrt((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            strafe *= f;
            up *= f;
            forward *= f;
            if (player.isInWater() || player.isInLava()) {
                strafe *= (float)player.getAttribute(Attributes.WATER_MOVEMENT_EFFICIENCY).getValue();
                up *= (float)player.getAttribute(Attributes.WATER_MOVEMENT_EFFICIENCY).getValue();
                forward *= (float)player.getAttribute(Attributes.WATER_MOVEMENT_EFFICIENCY).getValue();
            }
            float f1 = Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180)));
            float f2 = Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)));
            Vec3 deltaMovement = player.getDeltaMovement();
            player.setDeltaMovement(new Vec3(deltaMovement.x + (double)(strafe * f2 - forward * f1), deltaMovement.y + (double)up, deltaMovement.z + (double)(forward * f2 + strafe * f1)));
        }
    }

    public void onArmorTick(ItemStack itemStack, @Nonnull Level world, @Nonnull Player player) {
        int repaired;
        CompoundTag nbtData = ModUtils.nbt(itemStack);
        byte toggleTimer = nbtData.getByte("toggleTimer");
        boolean ret = false;
        int resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
        int n = repaired = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.REPAIRED, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.REPAIRED, (ItemStack)itemStack).number : 0;
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
            player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 300));
        }
        if (repaired != 0 && world.getGameTime() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxEnergy(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, resistance));
        }
        switch (this.getEquipmentSlot()) {
            case HEAD: {
                ArrayList effects = new ArrayList(player.getActiveEffects());
                for (MobEffectInstance effect : effects) {
                    Integer cost = this.potionRemovalCost.get(effect.getEffect());
                    if (cost == null || !ElectricItem.manager.canUse(itemStack, (cost = Integer.valueOf(cost * (effect.getAmplifier() + 1))).intValue())) continue;
                    ElectricItem.manager.use(itemStack, cost.intValue(), null);
                    IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)effect.getEffect());
                }
                boolean Nightvision = (Boolean)itemStack.getOrDefault(DataComponentsInit.NIGHT_VISION, (Object)false);
                if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = Nightvision = !Nightvision;
                    if (!world.isClientSide()) {
                        itemStack.set(DataComponentsInit.NIGHT_VISION, (Object)Nightvision);
                        if (!world.isClientSide()) {
                            if (Nightvision) {
                                IUCore.proxy.messagePlayer(player, "Nightvision enabled.");
                            } else {
                                IUCore.proxy.messagePlayer(player, "Nightvision disabled.");
                            }
                        }
                    }
                }
                if (!world.isClientSide() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.putByte("toggleTimer", toggleTimer);
                }
                if (Nightvision && !world.isClientSide && ElectricItem.manager.use(itemStack, 1.0, (LivingEntity)player)) {
                    int x = Mth.floor((double)player.getX());
                    int z = Mth.floor((double)player.getZ());
                    int y = Mth.floor((double)player.getY());
                    BlockPos pos = new BlockPos(x, y, z);
                    int skylight = player.level().getMaxLocalRawBrightness(pos);
                    boolean with = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITH);
                    boolean without = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITHOUT);
                    if (without || with) {
                        if (skylight > 8) {
                            IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)MobEffects.NIGHT_VISION);
                            if (with) {
                                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0, true, true));
                            }
                        } else {
                            if (with) {
                                IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)MobEffects.BLINDNESS);
                            }
                            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0));
                        }
                    } else {
                        player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0));
                    }
                    ret = true;
                }
                if (this.listCapability.contains((Object)EnumCapability.FOOD) && ElectricItem.manager.canUse(itemStack, 1000.0) && player.getFoodData().needsFood()) {
                    int slot = -1;
                    for (int i = 0; i < player.getInventory().items.size(); ++i) {
                        if (((ItemStack)player.getInventory().items.get(i)).isEmpty() || ((ItemStack)player.getInventory().items.get(i)).getItem().getFoodProperties((ItemStack)player.getInventory().items.get(i), (LivingEntity)player) == null) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemStack stack = (ItemStack)player.getInventory().items.get(slot);
                        if ((stack = player.eat(world, stack)).getCount() <= 0) {
                            player.getInventory().items.set(slot, (Object)ItemStack.EMPTY);
                        }
                        ElectricItem.manager.use(itemStack, 1000.0, (LivingEntity)player);
                        ret = true;
                    }
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WATER, itemStack)) {
                    player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 300));
                }
                if (!UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.NIGTHVISION, itemStack)) break;
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300));
                break;
            }
            case CHEST: {
                if (((Boolean)itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)false)).booleanValue()) {
                    player.fallDistance = 0.0f;
                    if (nbtData.getBoolean("jump") && !((Boolean)itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)false)).booleanValue() && !player.getAbilities().mayfly && IUCore.keyboard.isJumpKeyDown(player) && toggleTimer == 0) {
                        toggleTimer = 10;
                        itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)true);
                    }
                    nbtData.putBoolean("jump", !player.onGround());
                    if (!player.onGround()) {
                        if (ElectricItem.manager.canUse(itemStack, 45.0)) {
                            ElectricItem.manager.use(itemStack, 45.0, null);
                        } else {
                            itemStack.set(DataComponentsInit.JETPACK, (Object)false);
                        }
                    }
                }
                boolean jetpack = (Boolean)itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)false);
                boolean vertical = (Boolean)itemStack.getOrDefault(DataComponentsInit.VERTICAL, (Object)false);
                if (this.listCapability.contains((Object)EnumCapability.VERTICAL_FLY) && IUCore.keyboard.isVerticalMode(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = vertical = !vertical;
                    if (!world.isClientSide()) {
                        itemStack.set(DataComponentsInit.VERTICAL, (Object)vertical);
                        if (!world.isClientSide()) {
                            if (vertical) {
                                IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info2"));
                            } else {
                                IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info3"));
                            }
                        }
                    }
                }
                if (vertical && jetpack) {
                    double motion = 0.0;
                    if (IUCore.keyboard.isJumpKeyDown(player)) {
                        motion = 0.3;
                    }
                    if (player.isShiftKeyDown()) {
                        motion = -0.3;
                    }
                    Vec3 deltaMotion = player.getDeltaMovement();
                    player.setDeltaMovement(new Vec3(deltaMotion.x, deltaMotion.y + motion, deltaMotion.z));
                }
                if (IUCore.keyboard.isStreakKeyDown(player) && toggleTimer == 0 && IUItem.spectral_chestplate.getItem() == this) {
                    toggleTimer = 10;
                    if (!world.isClientSide()) {
                        this.save(itemStack, player);
                        CustomPacketBuffer growingBuffer = new CustomPacketBuffer(player.registryAccess());
                        growingBuffer.writeByte(3);
                        growingBuffer.flip();
                        player.openMenu((MenuProvider)this.getInventory(player, itemStack), buf -> buf.writeBytes((ByteBuf)growingBuffer));
                    }
                }
                int reTimer = nbtData.getInt("reTimer");
                if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY) && reTimer > 0) {
                    nbtData.putInt("reTimer", --reTimer);
                }
                if ((this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) && IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0 && reTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = jetpack = !jetpack;
                    if (!world.isClientSide()) {
                        itemStack.set(DataComponentsInit.JETPACK, (Object)jetpack);
                        if (jetpack) {
                            if (!world.isClientSide()) {
                                IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info"));
                            }
                            if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                                nbtData.putInt("timer", 600);
                            }
                        } else if (!world.isClientSide()) {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"));
                        }
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                    jetpack = (Boolean)itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)false);
                    int timer = nbtData.getInt("timer");
                    if (timer > 0) {
                        nbtData.putInt("timer", --timer);
                    } else if (jetpack) {
                        itemStack.set(DataComponentsInit.JETPACK, (Object)false);
                        nbtData.putInt("reTimer", 6000);
                        if (!world.isClientSide()) {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"));
                        }
                    }
                    boolean jetpackUsed = false;
                    if (!jetpack && IUCore.keyboard.isJumpKeyDown(player)) {
                        jetpackUsed = this.useJetpack(player);
                    }
                    if (world.isClientSide && player == IUCore.proxy.getPlayerInstance()) {
                        if (this.lastJetpackUsed != jetpackUsed) {
                            if (jetpackUsed) {
                                SoundHandler.playSound(player, "JetpackLoop");
                            }
                            this.lastJetpackUsed = jetpackUsed;
                            if (!this.lastJetpackUsed) {
                                SoundHandler.stopSound(EnumSound.JetpackLoop);
                            }
                        }
                        Random rnd = IUCore.random;
                        if (jetpackUsed) {
                            int i;
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)(player.getX() - player.getDeltaMovement().x) + rnd.nextFloat()), (double)((float)player.getY()), (double)((float)(player.getZ() - player.getDeltaMovement().z) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)(player.getX() - player.getDeltaMovement().x) + rnd.nextFloat()), (double)((float)player.getY()), (double)((float)(player.getZ() - player.getDeltaMovement().z) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                        }
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.JETPACK)) {
                    boolean jetpackUsed = false;
                    if (!jetpack && IUCore.keyboard.isJumpKeyDown(player)) {
                        jetpackUsed = this.useJetpack(player);
                    }
                    if (world.isClientSide && player == IUCore.proxy.getPlayerInstance()) {
                        if (this.lastJetpackUsed != jetpackUsed) {
                            if (jetpackUsed) {
                                SoundHandler.playSound(player, "JetpackLoop");
                            }
                            this.lastJetpackUsed = jetpackUsed;
                            if (!this.lastJetpackUsed) {
                                SoundHandler.stopSound(EnumSound.JetpackLoop);
                            }
                        }
                        Random rnd = IUCore.random;
                        if (jetpackUsed) {
                            int i;
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)(player.getX() - player.getDeltaMovement().x) + rnd.nextFloat()), (double)((float)player.getY()), (double)((float)(player.getZ() - player.getDeltaMovement().z) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)(player.getX() - player.getDeltaMovement().x) + rnd.nextFloat()), (double)((float)player.getY()), (double)((float)(player.getZ() - player.getDeltaMovement().z) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                        }
                    }
                }
                if (!world.isClientSide() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.putByte("toggleTimer", toggleTimer);
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack)) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300));
                }
                player.clearFire();
                break;
            }
            case LEGS: {
                if (this.listCapability.contains((Object)EnumCapability.SPEED) && ElectricItem.manager.canUse(itemStack, 1000.0) && (player.onGround() || player.isInWater()) && player.isSprinting()) {
                    byte speedTicker = nbtData.getByte("speedTicker");
                    if ((speedTicker = (byte)(speedTicker + 1)) >= 10) {
                        speedTicker = 0;
                        ElectricItem.manager.use(itemStack, 1000.0, null);
                        ret = true;
                    }
                    nbtData.putByte("speedTicker", speedTicker);
                    float speed = 0.22f;
                    if (player.isInWater()) {
                        speed = 0.1f;
                        if (IUCore.keyboard.isJumpKeyDown(player)) {
                            player.getDeltaMovement().add(0.0, (double)0.1f, 0.0);
                        }
                    }
                    this.moveRelative(player, 0.0f, 0.0f, 1.0f, speed);
                }
                if (this.listCapability.contains((Object)EnumCapability.BAGS) && IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isBootsMode(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    if (!world.isClientSide()) {
                        this.save(itemStack, player);
                        CustomPacketBuffer growingBuffer = new CustomPacketBuffer(player.registryAccess());
                        growingBuffer.writeByte(2);
                        growingBuffer.flip();
                        player.openMenu((MenuProvider)this.getInventory(player, itemStack), buf -> buf.writeBytes((ByteBuf)growingBuffer));
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.MAGNET)) {
                    int mode;
                    boolean magnet;
                    boolean bl = magnet = (Boolean)itemStack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false) == false;
                    if (IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isChangeKeyDown(player) && toggleTimer == 0) {
                        toggleTimer = 10;
                        if (!world.isClientSide()) {
                            if (magnet && !world.isClientSide()) {
                                IUCore.proxy.messagePlayer(player, "Magnet enabled.");
                            }
                            if (!magnet && !world.isClientSide()) {
                                IUCore.proxy.messagePlayer(player, "Magnet disabled.");
                            }
                            itemStack.set(DataComponentsInit.ACTIVE, (Object)magnet);
                        }
                    }
                    if (IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isSaveModeKeyDown(player) && toggleTimer == 0) {
                        toggleTimer = 10;
                        if (!world.isClientSide()) {
                            int mode2 = (Integer)itemStack.getOrDefault(DataComponentsInit.MODE, (Object)0);
                            if (++mode2 > 2 || mode2 < 0) {
                                mode2 = 0;
                            }
                            itemStack.set(DataComponentsInit.MODE, (Object)mode2);
                            if (!world.isClientSide()) {
                                IUCore.proxy.messagePlayer(player, String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode2));
                            }
                        }
                    }
                    if ((mode = ((Integer)itemStack.getOrDefault(DataComponentsInit.MODE, (Object)0)).intValue()) != 0) {
                        int radius = 11;
                        AABB axisalignedbb = new AABB(player.getX() - (double)radius, player.getY() - (double)radius, player.getZ() - (double)radius, player.getX() + (double)radius, player.getY() + (double)radius, player.getZ() + (double)radius);
                        if (world instanceof ServerLevel) {
                            LevelEntityGetter list1 = ((ServerLevel)world).getEntities();
                            ArrayList list = Lists.newArrayList();
                            list1.get(axisalignedbb, p_151522_ -> {
                                if (p_151522_ instanceof ItemEntity) {
                                    list.add(p_151522_);
                                }
                            });
                            boolean ret1 = false;
                            for (Entity entityinlist : list) {
                                boolean zcoord;
                                if (!(entityinlist instanceof ItemEntity)) continue;
                                ItemEntity item = (ItemEntity)entityinlist;
                                if (!ElectricItem.manager.canUse(itemStack, 200.0)) continue;
                                if (mode == 1) {
                                    item.moveTo(player.getX(), player.getY(), player.getZ(), 0.0f, 0.0f);
                                    if (!player.level().isClientSide) {
                                        ((ServerPlayer)player).connection.send((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                                    }
                                    item.setPickUpDelay(0);
                                    ElectricItem.manager.use(itemStack, 200.0, null);
                                    ret1 = true;
                                    continue;
                                }
                                if (mode != 2) continue;
                                boolean xcoord = item.getX() + 2.0 >= player.getX() && item.getX() - 2.0 <= player.getX();
                                boolean bl2 = zcoord = item.getZ() + 2.0 >= player.getZ() && item.getZ() - 2.0 <= player.getZ();
                                if (xcoord || zcoord) continue;
                                item.moveTo(player.getX(), player.getY() - 1.0, player.getZ());
                                item.setPickUpDelay(10);
                            }
                            if (ret1) {
                                player.containerMenu.broadcastChanges();
                            }
                        }
                    }
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SPEED, itemStack)) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300));
                }
                if (world.isClientSide() || toggleTimer <= 0) break;
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.putByte("toggleTimer", toggleTimer);
                break;
            }
            case FEET: {
                if (!world.isClientSide()) {
                    boolean wasOnGround;
                    boolean bl = wasOnGround = !nbtData.contains("wasOnGround") || nbtData.getBoolean("wasOnGround");
                    if (wasOnGround && !player.onGround() && IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isChangeKeyDown(player)) {
                        ElectricItem.manager.use(itemStack, 4000.0, null);
                        ret = true;
                    }
                    if (player.onGround() != wasOnGround) {
                        nbtData.putBoolean("wasOnGround", player.onGround());
                    }
                    if (ElectricItem.manager.canUse(itemStack, 4000.0) && player.onGround()) {
                        this.jumpCharge = 1.0f;
                    }
                    if (player.getDeltaMovement().y >= 0.0 && this.jumpCharge > 0.0f && !player.isInWater()) {
                        if (IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isBootsMode(player)) {
                            Vec3 deltaMovement = player.getDeltaMovement();
                            if (this.jumpCharge == 1.0f) {
                                player.setDeltaMovement(new Vec3(deltaMovement.x * 3.5, deltaMovement.y + (double)(this.jumpCharge * 0.6f), deltaMovement.z * 3.5));
                            }
                            this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                        } else if (this.jumpCharge < 1.0f) {
                            this.jumpCharge = 0.0f;
                        }
                    }
                }
                if (!UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.JUMP, itemStack)) break;
                player.addEffect(new MobEffectInstance(MobEffects.JUMP, 300));
            }
        }
        if (ret) {
            player.containerMenu.broadcastChanges();
        }
    }

    public void save(ItemStack stack, Player player) {
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, Player player) {
        return true;
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Item.TooltipContext p_41422_, List<Component> info, TooltipFlag p_41424_) {
        super.appendHoverText(itemStack, p_41422_, info, p_41424_);
        if (this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
            info.add((Component)Component.literal((String)(Localization.translate("iu.fly") + " " + ModUtils.Boolean((Boolean)itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)false)))));
        }
        if (!KeyboardIU.isKeyDown(340)) {
            info.add((Component)Component.literal((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            boolean with = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITH);
            boolean without = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITHOUT);
            boolean auto = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_AUTO);
            if (this.listCapability.contains((Object)EnumCapability.SPEED)) {
                info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_speed")));
            }
            if (with || without || auto) {
                info.add((Component)Component.literal((String)(Localization.translate("iu.special_armor_nightvision") + KeyboardClient.armormode.getKey().getDisplayName().getString())));
                if (with) {
                    info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_nightvision_1")));
                }
                if (without) {
                    info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_nightvision_2")));
                }
                if (auto) {
                    info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_nightvision_3")));
                }
            }
            if (this.listCapability.contains((Object)EnumCapability.BIG_JUMP)) {
                info.add((Component)Component.literal((String)(Localization.translate("iu.special armor big jump") + InputConstants.getKey((int)32, (int)32).getDisplayName().getString() + " + " + KeyboardClient.bootsmode.getKey().getDisplayName().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.AUTO_JUMP)) {
                info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_auto_jump")));
            }
            if (this.listCapability.contains((Object)EnumCapability.ACTIVE_EFFECT)) {
                info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_active_effect")));
            }
            if (this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
                info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_all_active_effect")));
            }
            if (this.listCapability.contains((Object)EnumCapability.BAGS)) {
                info.add((Component)Component.literal((String)("Open bag: " + KeyboardClient.bootsmode.getKey().getDisplayName().getString() + " + " + KeyboardClient.leggingsmode.getKey().getDisplayName().getString())));
                if (!itemStack.has(DataComponentsInit.DESCRIPTIONS_CONTAINER)) {
                    return;
                }
                List list = (List)itemStack.getOrDefault(DataComponentsInit.DESCRIPTIONS_CONTAINER, Collections.emptyList());
                for (BagsDescription description : list) {
                    info.add((Component)Component.literal((String)(description.getCount() + "x ")).append(description.getStack().getHoverName()).withStyle(ChatFormatting.GREEN));
                }
            }
            if (this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                info.add((Component)Component.literal((String)Localization.translate("iu.fly_need")));
                info.add((Component)Component.literal((String)(Localization.translate("iu.changemode_fly") + KeyboardClient.flymode.getKey().getDisplayName().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.VERTICAL_FLY)) {
                info.add((Component)Component.literal((String)(Localization.translate("iu.vertical") + KeyboardClient.verticalmode.getKey().getDisplayName().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.FOOD)) {
                info.add((Component)Component.translatable((String)Localization.translate("iu.food_mode_helmet")));
            }
            if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                String time3;
                String time2;
                String time1;
                double seconds;
                double minutes;
                double hours;
                List<Double> time;
                info.add((Component)Component.literal((String)Localization.translate("iu.jetpack_fly_chestplate")));
                CompoundTag nbt = ModUtils.nbt(itemStack);
                int reTimer = nbt.getInt("reTimer");
                int timer = nbt.getInt("timer");
                if (timer > 0) {
                    time = ModUtils.Time((double)timer / 20.0);
                    hours = 0.0;
                    minutes = 0.0;
                    seconds = 0.0;
                    if (time.size() > 0) {
                        hours = time.get(0);
                        minutes = time.get(1);
                        seconds = time.get(2);
                    }
                    time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
                    time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
                    time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
                    info.add((Component)Component.literal((String)(Localization.translate("iu.timetoend") + time1 + time2 + time3 + " " + Localization.translate("iu.jetpack_fly_chestplate_2"))));
                }
                if (reTimer > 0) {
                    time = ModUtils.Time((double)reTimer / 20.0);
                    hours = 0.0;
                    minutes = 0.0;
                    seconds = 0.0;
                    if (time.size() > 0) {
                        hours = time.get(0);
                        minutes = time.get(1);
                        seconds = time.get(2);
                    }
                    time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
                    time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
                    time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
                    info.add((Component)Component.translatable((String)(Localization.translate("iu.timetoend") + time1 + time2 + time3 + " " + Localization.translate("iu.jetpack_fly_chestplate_1"))));
                }
            }
            if (itemStack.getItem() == IUItem.spectral_chestplate.getItem()) {
                info.add((Component)Component.literal((String)(Localization.translate("iu.streak") + KeyboardClient.streakmode.getKey().getDisplayName().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.MAGNET)) {
                info.add((Component)Component.literal((String)(Localization.translate("iu.magnet_mode") + KeyboardClient.changemode.getKey().getDisplayName().getString() + " + " + KeyboardClient.leggingsmode.getKey().getDisplayName().getString())));
                info.add((Component)Component.literal((String)(Localization.translate("iu.changemode_key") + KeyboardClient.leggingsmode.getKey().getDisplayName().getString() + " + " + KeyboardClient.savemode.getKey().getDisplayName().getString())));
                int mode = (Integer)itemStack.getOrDefault(DataComponentsInit.MODE, (Object)0);
                if (mode > 2 || mode < 0) {
                    mode = 0;
                }
                info.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode))));
            }
        }
        ModUtils.mode(itemStack, info);
    }

    public boolean useJetpack(Player player) {
        ItemStack jetpack = (ItemStack)player.getInventory().armor.get(2);
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = true;
        float power = 0.7f;
        float dropPercentage = 0.05f;
        if (this.getCharge(jetpack) / this.getMaxEnergy(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxEnergy(jetpack) * (double)dropPercentage)));
        }
        if (IUCore.keyboard.isForwardKeyDown(player)) {
            float retruster = 0.15f;
            float forwardpower = power * (retruster += 0.15f) * 2.0f;
            if (forwardpower > 0.0f) {
                player.moveRelative(0.0f, new Vec3(0.0, (double)(0.4f * forwardpower), (double)0.02f));
            }
        }
        int worldHeight = player.level().getHeight();
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        double y = player.getY();
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        Vec3 affectedMotion = player.getDeltaMovement();
        double moveY = Math.min(affectedMotion.y + (double)(power * 0.2f), (double)0.6f);
        player.setDeltaMovement(affectedMotion.x, moveY, affectedMotion.z);
        int consume = 2;
        consume += 6;
        if (!player.onGround()) {
            this.use(jetpack, consume);
        }
        player.fallDistance = 0.0f;
        player.walkDist = 0.0f;
        return true;
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (!event.getEntity().level().isClientSide() && event.getEntity() instanceof LivingEntity) {
            LivingEntity entity = event.getEntity();
            ItemStack armor = entity.getItemBySlot(EquipmentSlot.FEET);
            if (armor.getItem() == this) {
                int fallDamage = Math.max((int)event.getDistance() - 10, 0);
                double energyCost = this.armor.getDamageEnergy() * (double)fallDamage * (1.0 - (double)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FALLING_DAMAGE, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FALLING_DAMAGE, (ItemStack)armor).number : 0) * 0.25);
                if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                    ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                    event.setCanceled(true);
                }
            }
            if (entity instanceof Player && entity.getItemBySlot(EquipmentSlot.CHEST).getItem() == this && entity.getPersistentData().getBoolean("isFlyActive")) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack var1) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack var1) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack var1) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack var1) {
        return this.transferLimit;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.is(DamageTypeTags.IS_FALL) && this.getEquipmentSlot().getIndex() == 0) {
            int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
            int energyPerDamage = (int)(this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect);
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int energyPerDamage = (int)(this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect);
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(10, absorptionRatio, damageLimit);
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public int getArmorDisplay(Player player, @Nonnull ItemStack armor, int slot) {
        return ElectricItem.manager.getCharge(armor) >= this.armor.getDamageEnergy() ? (int)Math.round(40.0 * this.getBaseAbsorptionRatio()) : 0;
    }

    private double getBaseAbsorptionRatio() {
        switch (this.getEquipmentSlot()) {
            case FEET: {
                return this.armor.getArmorMulDamage().getBootsMul();
            }
            case HEAD: {
                return this.armor.getArmorMulDamage().getHeadMul();
            }
            case CHEST: {
                return this.armor.getArmorMulDamage().getChestMul();
            }
            case LEGS: {
                return this.armor.getArmorMulDamage().getLeggingsMul();
            }
        }
        return 1.0;
    }

    @Override
    public void damageArmor(LivingEntity entity, @NotNull ItemStack stack, DamageSource source, float damage, int slot) {
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)stack).number : 0;
        ElectricItem.manager.discharge(stack, (double)damage * (this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> items) {
        if (this.allowedIn(p_41391_)) {
            ItemStack stack = new ItemStack((ItemLike)this, 1);
            CompoundTag nbt = ModUtils.nbt(stack);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            nbt.putInt("ID_Item", Integer.MAX_VALUE);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((ItemLike)this, 1);
            nbt = ModUtils.nbt(itemstack);
            nbt.putInt("ID_Item", Integer.MAX_VALUE);
            items.add((Object)itemstack);
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }
}

