/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.tile.IWrenchable;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.componets.AbstractComponent;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.energy.ItemTreetap;
import com.denfop.proxy.CommonProxy;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;

public class ItemGraviTool
extends TieredItem
implements IEnergyItem,
IUpgradeItem,
IProperties,
IItemTab {
    protected static final double ROTATE = 50.0;
    protected static final double HOE = 50.0;
    protected static final double TAP = 50.0;
    private String nameItem;

    public ItemGraviTool() {
        super((Tier)Tiers.IRON, new Item.Properties().stacksTo(1).setNoRepair().component(DataComponentsInit.MODE, (Object)0));
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, this.getUpgradeModules()));
    }

    public static GraviToolMode readToolMode(ItemStack stack) {
        return GraviToolMode.getFromID((Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0));
    }

    public static GraviToolMode readNextToolMode(ItemStack stack) {
        return GraviToolMode.getFromID((Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0) + 1);
    }

    public static void saveToolMode(ItemStack stack, GraviToolMode mode) {
        stack.set(DataComponentsInit.MODE, (Object)mode.ordinal());
    }

    public static boolean hasNecessaryPower(ItemStack stack, double usage, Player player) {
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        return ElectricItem.manager.canUse(stack, usage * coef);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, Player player) {
        return ItemGraviTool.checkNecessaryPower(stack, usage, player, false);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, Player player, boolean supressSound) {
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        if (ElectricItem.manager.use(stack, usage * coef, (LivingEntity)player)) {
            if (supressSound || player.level().isClientSide) {
                // empty if block
            }
            return true;
        }
        CommonProxy.sendPlayerMessage(player, Localization.translate("message.text.noenergy"));
        return false;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item.GraviTool";
        }
        return this.nameItem;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        return (float)ItemGraviTool.readToolMode(itemStack).ordinal() * 0.25f;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility) && ItemGraviTool.readToolMode(stack) == GraviToolMode.HOE;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            ItemStack stack = ModUtils.get(player, hand);
            if (world.isClientSide) {
                player.playSound(EnumSound.toolchange.getSoundEvent(), 1.0f, 1.0f);
            } else {
                GraviToolMode mode = ItemGraviTool.readNextToolMode(stack);
                ItemGraviTool.saveToolMode(stack, mode);
                CommonProxy.sendPlayerMessage(player, String.valueOf(mode.colour) + Localization.translate(mode.translationName));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.use(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        GraviToolMode mode = ItemGraviTool.readToolMode(stack);
        tooltip.add((Component)Component.translatable((String)"message.text.mode").append(": " + String.valueOf(mode.colour)).append((Component)Component.translatable((String)mode.translationName)));
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.translatable((String)"iu.changemode_key").append(" " + KeyboardClient.changemode.getKey().getDisplayName().getString()).append((Component)Component.translatable((String)"iu.changemode_rcm")));
        }
        super.appendHoverText(stack, world, tooltip, flag);
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@Nonnull ItemStack stack, @Nonnull UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        return switch (ItemGraviTool.readToolMode(stack).ordinal()) {
            case 2 -> {
                if (this.onWrenchUse(stack, player, level, pos, context.getClickedFace())) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.FAIL;
            }
            case 3 -> {
                if (this.onScrewdriverUse(stack, player, level, pos)) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.FAIL;
            }
            default -> super.onItemUseFirst(stack, context);
        };
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos, context.isInside());
        if (player == null) {
            return InteractionResult.PASS;
        }
        switch (ItemGraviTool.readToolMode(stack).ordinal()) {
            case 0: {
                return this.onHoeUse(stack, player, level, pos, hitResult.getDirection()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            case 1: {
                return this.onTreeTapUse(stack, player, level, pos, hitResult.getDirection()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            case 4: {
                TileEntityInventory base;
                BlockEntity tile = level.getBlockEntity(pos);
                if (!(tile instanceof TileEntityInventory) && !(tile instanceof IManufacturerBlock)) {
                    return InteractionResult.PASS;
                }
                double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
                if (tile instanceof TileEntityInventory) {
                    base = (TileEntityInventory)tile;
                    double energy = 10000.0;
                    if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PURIFIER, stack)) {
                        energy = 0.0;
                    }
                    if (!base.canEntityDestroy((Entity)player)) {
                        return InteractionResult.FAIL;
                    }
                    for (AbstractComponent component : base.getComponentList()) {
                        if (!component.canUsePurifier(player) || !ElectricItem.manager.canUse(stack, energy * coef)) continue;
                        component.workPurifier();
                        return InteractionResult.SUCCESS;
                    }
                }
                if (tile instanceof TileMultiMachine) {
                    if (!ElectricItem.manager.canUse(stack, 500.0 * coef)) {
                        return InteractionResult.PASS;
                    }
                    base = (TileMultiMachine)tile;
                    ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                    if (((TileMultiMachine)base).multi_process.quickly) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_quickly.getItem()));
                        ((TileMultiMachine)base).multi_process.setQuickly(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).multi_process.modulesize) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_stack.getItem()));
                        ((TileMultiMachine)base).multi_process.setModulesize(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).multi_process.module_separate) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_separate.getItem()));
                        ((TileMultiMachine)base).multi_process.module_separate = false;
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).solartype != null) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module6.getStack(((TileMultiMachine)base).solartype.meta), 1));
                        ((TileMultiMachine)base).solartype = null;
                    }
                    if (((TileMultiMachine)base).multi_process.modulestorage) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_storage.getItem()));
                        ((TileMultiMachine)base).multi_process.setModulestorage(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).multi_process.module_infinity_water) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_infinity_water.getItem()));
                        ((TileMultiMachine)base).multi_process.module_infinity_water = false;
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    for (ItemStack dropStack : stackList) {
                        if (level.isClientSide) continue;
                        ItemEntity itemEntity = new ItemEntity((Level)((ServerLevel)level), player.getX(), player.getY(), player.getZ(), dropStack);
                        itemEntity.setPickUpDelay(0);
                        level.addFreshEntity((Entity)itemEntity);
                        player.playNotifySound(EnumSound.purifier.getSoundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    ElectricItem.manager.use(stack, 500.0 * coef, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    protected boolean onHoeUse(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        if (player.mayUseItemAt(pos.relative(side), side, stack) && ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            BlockState state1 = world.getBlockState(pos.below());
            if (side != Direction.DOWN && !state1.isAir()) {
                if (block == Blocks.GRASS_BLOCK || block == Blocks.DIRT_PATH) {
                    return this.setHoedBlock(stack, player, world, pos, Blocks.FARMLAND.defaultBlockState());
                }
                if (block == Blocks.DIRT) {
                    return this.setHoedBlock(stack, player, world, pos, Blocks.FARMLAND.defaultBlockState());
                }
                if (block == Blocks.COARSE_DIRT) {
                    return this.setHoedBlock(stack, player, world, pos, Blocks.DIRT.defaultBlockState());
                }
            }
            return false;
        }
        return false;
    }

    protected boolean setHoedBlock(ItemStack stack, Player player, Level world, BlockPos pos, BlockState state) {
        if (ItemGraviTool.checkNecessaryPower(stack, 50.0, player, true)) {
            world.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.isClientSide) {
                world.setBlock(pos, state, 11);
            }
            return true;
        }
        return false;
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.isClientSide && !UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }

    protected boolean onTreeTapUse(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        BlockState state = world.getBlockState(pos);
        return ItemGraviTool.hasNecessaryPower(stack, 50.0, player) && (state.getBlock() == IUItem.rubWood.getBlock().get() && ItemTreetap.attemptExtract(player, world, pos, side, state, null) || state.getBlock() == IUItem.swampRubWood.getBlock().get() && ItemTreetap.attemptSwampExtract(player, world, pos, side, state, null) || state.getBlock() == IUItem.tropicalRubWood.getBlock().get() && ItemTreetap.attemptTropicalExtract(player, world, pos, side, state, null)) && ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
    }

    protected boolean onWrenchUse(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (state.isAir()) {
            return false;
        }
        if (block instanceof IWrenchable) {
            Direction newFacing;
            IWrenchable wrenchable = (IWrenchable)block;
            Direction current = wrenchable.getFacing(world, pos);
            if (!IUCore.keyboard.isChangeKeyDown(player)) {
                newFacing = player.isShiftKeyDown() ? side.getOpposite() : side;
            } else {
                Direction.Axis axis = side.getAxis();
                newFacing = !(!player.isShiftKeyDown() && side.getAxisDirection() == Direction.AxisDirection.POSITIVE || player.isShiftKeyDown() && side.getAxisDirection() == Direction.AxisDirection.NEGATIVE) ? current.getCounterClockWise(axis).getCounterClockWise(axis).getCounterClockWise(axis) : current.getClockWise(axis);
            }
            if (current != newFacing) {
                if (!ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
                    return false;
                }
                if (wrenchable.setFacing(world, pos, newFacing, player)) {
                    player.playSound(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
                    return ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
                }
            }
            if (wrenchable.wrenchCanRemove(world, pos, player)) {
                if (!ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
                    return false;
                }
                player.playSound(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
                if (!world.isClientSide) {
                    BlockEvent.BreakEvent experience;
                    BlockEntity te = world.getBlockEntity(pos);
                    if (player instanceof ServerPlayer && (experience = CommonHooks.fireBlockBreak((Level)world, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos, (BlockState)state)).isCanceled()) {
                        return false;
                    }
                    block.playerWillDestroy(world, pos, state, player);
                    if (!block.onDestroyedByPlayer(state, world, pos, player, true, world.getFluidState(pos))) {
                        return false;
                    }
                    int fortune = world.random.nextInt(100);
                    if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WRENCH, stack)) {
                        fortune = 100;
                    }
                    for (ItemStack drop : wrenchable.getWrenchDrops(world, pos, state, te, player, fortune)) {
                        ModUtils.dropAsEntity(world, pos, drop);
                    }
                    wrenchable.wrenchBreak(world, pos);
                }
                return ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
            }
        }
        return false;
    }

    protected boolean onScrewdriverUse(ItemStack stack, Player player, Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (!state.isAir() && block instanceof HorizontalDirectionalBlock && ItemGraviTool.checkNecessaryPower(stack, 500.0, player)) {
            Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            facing = player.isShiftKeyDown() ? facing.getCounterClockWise() : facing.getClockWise();
            world.setBlock(pos, (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing), 3);
            return true;
        }
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return 300000.0;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return 10000.0;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.GRAVITOOL.list;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    public static enum GraviToolMode {
        HOE(ChatFormatting.GOLD),
        TREETAP(ChatFormatting.LIGHT_PURPLE),
        WRENCH(ChatFormatting.AQUA),
        SCREWDRIVER(ChatFormatting.YELLOW),
        PURIFIER(ChatFormatting.DARK_AQUA);

        private static final GraviToolMode[] VALUES;
        public final String translationName = "iu.graviTool.snap." + this.name().toLowerCase(Locale.ENGLISH);
        public final ChatFormatting colour;

        private GraviToolMode(ChatFormatting colour) {
            this.colour = colour;
        }

        public static GraviToolMode getFromID(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = GraviToolMode.values();
        }
    }
}

