/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.audio.SoundHandler;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.network.packet.PacketStopSoundPlayer;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;

public class ItemNanoSaber
extends TieredItem
implements IEnergyItem,
IUpgradeItem,
IProperties,
IItemTab {
    public static int ticker = 0;
    public final int maxCharge;
    public final int transferLimit;
    public final int tier;
    private final int damage1;
    public int activedamage;
    private int soundTicker = 0;
    private boolean wasEquipped;
    private String nameItem;

    public ItemNanoSaber(int maxCharge, int transferLimit, int tier, int activedamage1, int damage) {
        super((Tier)Tiers.DIAMOND, new Item.Properties().setNoRepair().setNoRepair().stacksTo(1).component(DataComponentsInit.MODE, (Object)0).component(DataComponentsInit.ENERGY, (Object)0.0).component(DataComponentsInit.ACTIVE, (Object)false).component(DataComponents.TOOL, (Object)SwordItem.createToolProperties()));
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.activedamage = activedamage1;
        this.damage1 = damage;
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SABERS.list));
    }

    private static boolean isActive(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false);
    }

    private static void setActive(ItemStack stack, boolean active) {
        stack.set(DataComponentsInit.ACTIVE, (Object)active);
    }

    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !pPlayer.isCreative();
    }

    public float getDestroySpeed(ItemStack pStack, BlockState pState) {
        if (pState.is(Blocks.COBWEB)) {
            return 15.0f;
        }
        return pState.is(BlockTags.SWORD_EFFICIENT) ? 1.5f : 1.0f;
    }

    public boolean isCorrectToolForDrops(ItemStack p_336002_, BlockState pBlock) {
        return pBlock.is(Blocks.COBWEB);
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.nano_saber";
        }
        return this.nameItem;
    }

    @Override
    public String[] properties() {
        return new String[]{"active"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel world, LivingEntity entityIn, int p174679, String property) {
        return (Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false) != false ? 1.0f : 0.0f;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility);
    }

    public String getRandomSwingSound() {
        switch (IUCore.random.nextInt(3)) {
            default: {
                return "nanosabreswing1";
            }
            case 1: {
                return "nanosabreswing2";
            }
            case 2: 
        }
        return "nanosabreswing3";
    }

    public boolean mineBlock(ItemStack itemstack, Level p_41417_, BlockState p_41418_, BlockPos p_41419_, LivingEntity p_41420_) {
        if (ItemNanoSaber.isActive(itemstack)) {
            this.drainSaber(itemstack, 80.0, p_41420_);
        }
        return false;
    }

    public void drainSaber(ItemStack itemStack, double amount, LivingEntity entity) {
        int saberenergy;
        int n = saberenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABERENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABERENERGY, (ItemStack)itemStack).number : 0;
        if (!ElectricItem.manager.use(itemStack, amount - amount * 0.15 * (double)saberenergy, entity)) {
            ItemNanoSaber.setActive(itemStack, false);
        }
    }

    protected String getIdleSound() {
        return "NanosabreIdle".toLowerCase();
    }

    protected String getStartSound() {
        return "NanosabrePowerup".toLowerCase();
    }

    protected void removeAudioSource() {
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            if (!IUCore.keyboard.isChangeKeyDown(player)) {
                if (ItemNanoSaber.isActive(stack)) {
                    ItemNanoSaber.setActive(stack, false);
                    new PacketStopSoundPlayer(EnumSound.NanosabreIdle, player);
                    player.containerMenu.broadcastChanges();
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
                }
                if (ElectricItem.manager.canUse(stack, 16.0)) {
                    ItemNanoSaber.setActive(stack, true);
                    new PacketSoundPlayer(this.getStartSound(), player);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
                }
                return super.use(world, player, hand);
            }
            int mode = (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0);
            stack.set(DataComponentsInit.MODE, (Object)(mode == 0 ? 1 : 0));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.translatable((String)"iu.changemode_key").append(KeyboardClient.changemode.getKey().getDisplayName()).append((Component)Component.translatable((String)"iu.changemode_rcm")));
        }
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
        int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
        if (ElectricItem.manager.canUse(stack, 400.0) && ItemNanoSaber.isActive(stack)) {
            dmg = (int)((double)this.activedamage + (double)this.activedamage * 0.15 * (double)saberdamage);
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int slot, boolean p_41408_) {
        super.inventoryTick(itemStack, world, entity, slot, p_41408_);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
        if (world.isClientSide && ItemNanoSaber.isActive(itemStack) && world.getGameTime() % 20L == 0L) {
            SoundHandler.playSound(IUCore.proxy.getPlayerInstance(), this.getIdleSound());
        }
        if (!ItemNanoSaber.isActive(itemStack)) {
            return;
        }
        if (ticker % 16 == 0 && entity instanceof ServerPlayer) {
            if (slot < 9) {
                this.drainSaber(itemStack, 64.0, (LivingEntity)((ServerPlayer)entity));
            } else if (ticker % 64 == 0) {
                this.drainSaber(itemStack, 16.0, (LivingEntity)((ServerPlayer)entity));
            }
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        this.removeAudioSource();
        return super.onDroppedByPlayer(item, player);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity source) {
        if (!ItemNanoSaber.isActive(stack)) {
            return true;
        }
        if (!target.level().isClientSide) {
            this.drainSaber(stack, 400.0, source);
            int vampires = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.VAMPIRES, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.VAMPIRES, (ItemStack)stack).number : 0;
            boolean wither = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WITHER, stack);
            boolean poison = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.POISON, stack);
            if (vampires != 0) {
                target.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 40, vampires));
            }
            if (wither) {
                target.addEffect(new MobEffectInstance(MobEffects.WITHER, 60));
            }
            if (poison) {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 60));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.HUNGRY, stack)) {
                target.addEffect(new MobEffectInstance(MobEffects.HUNGER, 60));
            }
            if (source instanceof ServerPlayer) {
                new PacketSoundPlayer(this.getRandomSwingSound(), (Player)source);
            }
            int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
            int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
            int attackMode = (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0);
            if (ElectricItem.manager.canUse(stack, 400.0)) {
                if (ItemNanoSaber.isActive(stack)) {
                    dmg = (int)((double)this.activedamage + (double)this.activedamage * 0.15 * (double)saberdamage);
                }
                if (attackMode != 0) {
                    this.areaAttack(stack, target, source, 2, dmg);
                }
            }
        }
        return true;
    }

    private void areaAttack(ItemStack stack, LivingEntity target, LivingEntity source, int radius, double damage) {
        List entities = source.level().getEntitiesOfClass(LivingEntity.class, source.getBoundingBox().inflate((double)radius));
        for (LivingEntity entity : entities) {
            if (entity == source || entity == target) continue;
            entity.hurt(source.damageSources().playerAttack((Player)source), (float)damage);
        }
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return false;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SABERS.list;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }
}

