/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.panels.entity.EnumSolarPanels;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PacketChangeSolarPanel
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketChangeSolarPanel() {
    }

    public PacketChangeSolarPanel(EnumSolarPanels typePacket, TileSolarPanel tileEntityBlock) {
        Level world = tileEntityBlock.getWorld();
        BlockPos pos = tileEntityBlock.getBlockPos();
        byte facing = tileEntityBlock.facing;
        tileEntityBlock.debt = 0.0;
        tileEntityBlock.deptPercent = 0.0;
        CompoundTag tagCompound = tileEntityBlock.writeToNBT(new CompoundTag());
        List<ItemStack> list = tileEntityBlock.pollution.getDrops();
        typePacket = typePacket.solarold;
        ItemStack stack = new ItemStack(typePacket.block.getItem(typePacket.meta), 1);
        ItemBlockTileEntity itemBlockTileEntity = (ItemBlockTileEntity)stack.getItem();
        tileEntityBlock.onUnloaded();
        FakePlayerSpawner fakePlayerSpawner = new FakePlayerSpawner(world);
        tileEntityBlock.getWorld().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        tileEntityBlock.getWorld().removeBlockEntity(pos);
        fakePlayerSpawner.startUsingItem(InteractionHand.MAIN_HAND);
        fakePlayerSpawner.setItemInHand(InteractionHand.MAIN_HAND, stack);
        UseOnContext context = new UseOnContext((Player)fakePlayerSpawner, fakePlayerSpawner.getUsedItemHand(), new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.values()[facing], pos, false));
        itemBlockTileEntity.useOn(context);
        TileSolarPanel tileSolarPanel = (TileSolarPanel)world.getBlockEntity(pos);
        if (tileSolarPanel != null) {
            tileSolarPanel.readFromNBT(tagCompound);
            if (!list.isEmpty()) {
                fakePlayerSpawner.setItemInHand(InteractionHand.MAIN_HAND, list.get(0));
                tileSolarPanel.pollution.onBlockActivated((Player)fakePlayerSpawner, fakePlayerSpawner.getUsedItemHand());
            }
        }
        tileSolarPanel.onLoaded();
        CustomPacketBuffer buffer = new CustomPacketBuffer(tileEntityBlock.getLevel().registryAccess());
        buffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(buffer, pos);
            EncoderHandler.encode(buffer, tagCompound);
            buffer.writeBytes((ByteBuf)tileSolarPanel.pollution.updateComponent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer = buffer;
        IUCore.network.getServer().sendPacket(this);
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return -99;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            CompoundTag tagCompound = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
            TileSolarPanel tileSolarPanel = (TileSolarPanel)entityPlayer.level().getBlockEntity(pos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

