/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.register.Register;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PlanetRecipe
implements Recipe<CraftingInput> {
    private final String recipeType;
    private final List<ItemStack> inputs;
    private final String typeOperation;
    public String name;
    public String systemName;
    public String texturePath;
    public EnumLevels level = EnumLevels.FIVE;
    public String starName;
    public Integer temperature;
    public Boolean pressure;
    public Double distance;
    public EnumType type = EnumType.NEUTRAL;
    public Boolean oxygen;
    public Boolean colonies;
    public Integer angle;
    public Double time;
    public Double size;
    public Double rotation;

    public PlanetRecipe(String recipeType, List<ItemStack> inputs, String typeOperation) {
        this.recipeType = recipeType;
        this.inputs = inputs;
        this.typeOperation = typeOperation;
    }

    public boolean matches(CraftingInput inv, Level world) {
        return false;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public List<IInputItemStack> getInputs() {
        ArrayList<IInputItemStack> inputItemStackList = new ArrayList<IInputItemStack>();
        this.inputs.forEach(input -> inputItemStackList.add(new InputItemStack((ItemStack)input)));
        return inputItemStackList;
    }

    public String getTypeOperation() {
        return this.typeOperation;
    }

    public String getRecipeType() {
        return this.recipeType;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Register.RECIPE_SERIALIZER_PLANET_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Register.PLANET_RECIPE.get();
    }
}

