/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IStar;
import com.denfop.api.space.ISystem;
import com.denfop.api.space.Planet;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.PlanetRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class PlanetSerializer
implements RecipeSerializer<PlanetRecipe> {
    public static final MapCodec<PlanetRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(p -> p.name), (App)Codec.STRING.fieldOf("system").forGetter(p -> p.systemName), (App)Codec.STRING.fieldOf("texture").forGetter(p -> p.texturePath), (App)Codec.STRING.xmap(EnumLevels::valueOf, Enum::name).fieldOf("level").forGetter(p -> p.level), (App)Codec.STRING.fieldOf("star").forGetter(p -> p.starName), (App)Codec.INT.fieldOf("temperature").forGetter(p -> p.temperature), (App)Codec.BOOL.fieldOf("pressure").forGetter(p -> p.pressure), (App)Codec.DOUBLE.fieldOf("distance").forGetter(p -> p.distance), (App)Codec.STRING.xmap(EnumType::valueOf, Enum::name).fieldOf("type").forGetter(p -> p.type), (App)Codec.BOOL.fieldOf("oxygen").forGetter(p -> p.oxygen), (App)Codec.BOOL.fieldOf("colonies").forGetter(p -> p.colonies), (App)Codec.INT.fieldOf("angle").forGetter(p -> p.angle), (App)Codec.DOUBLE.fieldOf("time").forGetter(p -> p.time), (App)Codec.DOUBLE.fieldOf("size").forGetter(p -> p.size), (App)Codec.DOUBLE.fieldOf("rotation").forGetter(p -> p.rotation)).apply((Applicative)instance, (name, systemStr, textureStr, levelStr, starStr, temp, pressure, distance, typeStr, oxygen, colonies, angle, time, size, rotation) -> {
        ISystem system = SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr));
        IStar star = (IStar)SpaceNet.instance.getBodyFromName((String)starStr);
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        SpaceInit.regPlanet.add(() -> new Planet((String)name, system, texture, (EnumLevels)((Object)((Object)levelStr)), star, (int)temp, (boolean)pressure, (double)distance, (EnumType)((Object)((Object)typeStr)), (boolean)oxygen, (boolean)colonies, (int)angle, (double)time, (double)size, (double)rotation));
        return new PlanetRecipe("", Collections.emptyList(), "");
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlanetRecipe> STREAM_CODEC = StreamCodec.of(PlanetSerializer::toNetwork, PlanetSerializer::fromNetwork);

    private static PlanetRecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
        return new PlanetRecipe("", new ArrayList<ItemStack>(), "");
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, PlanetRecipe p_320586_) {
    }

    public MapCodec<PlanetRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PlanetRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

